/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.common.puzzle;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import re.belv.croiseur.common.puzzle.PuzzleGrid;

public record PuzzleClues(List<String> across, List<String> down) {
    private static final PuzzleClues EMPTY = new PuzzleClues(Collections.emptyList(), Collections.emptyList());

    public PuzzleClues {
        Objects.requireNonNull(across);
        Objects.requireNonNull(down);
    }

    public static PuzzleClues from(Map<String, String> clues, PuzzleGrid grid) {
        List<String> across = grid.acrossSlotContents().stream().map(word -> clues.getOrDefault(word, "")).toList();
        List<String> down = grid.downSlotContents().stream().map(word -> clues.getOrDefault(word, "")).toList();
        return new PuzzleClues(across, down);
    }

    public static PuzzleClues empty() {
        return EMPTY;
    }
}

