/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.common.puzzle;

import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;

public record PuzzleDetails(String title, String author, String editor, String copyright, Optional<LocalDate> date) {
    private static final PuzzleDetails EMPTY = new PuzzleDetails("", "", "", "", Optional.empty());

    public PuzzleDetails {
        Objects.requireNonNull(title, "Puzzle title shall not be null, use an empty String.");
        Objects.requireNonNull(editor, "Puzzle editor shall not be null, use an empty String.");
        Objects.requireNonNull(copyright, "Puzzle copyright shall not be null, use an empty String.");
        Objects.requireNonNull(date, "Puzzle date shall not be null, use an empty Optional.");
    }

    public static PuzzleDetails empty() {
        return EMPTY;
    }

    public static PuzzleDetails emptyOfToday() {
        return new PuzzleDetails("", "", "", "", Optional.of(LocalDate.now()));
    }
}

