/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.common.puzzle;

import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import re.belv.croiseur.common.puzzle.GridPosition;
import re.belv.croiseur.common.puzzle.PuzzleGrid;

public final class PuzzleGridParser {
    private static final Pattern CHARACTER_SEPARATOR = Pattern.compile("(\\|)");
    private static final Character SHADED_CHARACTER = Character.valueOf('#');

    private PuzzleGridParser() {
    }

    public static PuzzleGrid parse(String puzzle) {
        HashSet<GridPosition> shaded = new HashSet<GridPosition>();
        HashMap<GridPosition, Character> prefilled = new HashMap<GridPosition, Character>();
        String[] lines = PuzzleGridParser.splitLines(puzzle);
        int height = lines.length;
        int width = (int)CHARACTER_SEPARATOR.matcher(lines[0]).results().count() - 1;
        for (int y = 0; y < height; ++y) {
            String[] characters = CHARACTER_SEPARATOR.split(lines[y].substring(1));
            for (int x = 0; x < width; ++x) {
                String parsed = characters[x].trim();
                if (parsed.isEmpty()) continue;
                Character character = Character.valueOf(parsed.charAt(0));
                GridPosition gridPosition = new GridPosition(x, y);
                if (character.equals(SHADED_CHARACTER)) {
                    shaded.add(gridPosition);
                    continue;
                }
                prefilled.put(gridPosition, character);
            }
        }
        return new PuzzleGrid(width, height, shaded, prefilled);
    }

    private static String[] splitLines(String puzzle) {
        return puzzle.replace("\r\n", "\n").split("\n");
    }
}

