/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.spi.presenter;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import re.belv.croiseur.common.dictionary.DictionaryProviderDetails;
import re.belv.croiseur.common.dictionary.ProvidedDictionaryDetails;
import re.belv.croiseur.common.puzzle.PuzzleCodecDetails;
import re.belv.croiseur.common.puzzle.SavedPuzzle;
import re.belv.croiseur.spi.presenter.Presenter;
import re.belv.croiseur.spi.presenter.clue.ClueProviderDescription;
import re.belv.croiseur.spi.presenter.dictionary.DictionaryContent;
import re.belv.croiseur.spi.presenter.dictionary.DictionarySearchResult;
import re.belv.croiseur.spi.presenter.puzzle.PuzzlePresenter;
import re.belv.croiseur.spi.presenter.solver.SolverDescription;
import re.belv.croiseur.spi.presenter.solver.SolverInitialisationState;
import re.belv.croiseur.spi.presenter.solver.SolverProgress;
import re.belv.croiseur.spi.presenter.solver.SolverResult;

final class BroadcastingPresenter
implements Presenter {
    private final Iterable<? extends Presenter> presenters;

    BroadcastingPresenter(Iterable<? extends Presenter> presentersArg) {
        this.presenters = Objects.requireNonNull(presentersArg, "Iterable passed to broadcasting presenter shall not be null");
    }

    @Override
    public void presentDictionaryProviders(Collection<DictionaryProviderDetails> providers) {
        this.presenters.forEach(p -> p.presentDictionaryProviders(providers));
    }

    @Override
    public void presentDictionaries(List<ProvidedDictionaryDetails> dictionaries) {
        this.presenters.forEach(p -> p.presentDictionaries(dictionaries));
    }

    @Override
    public void presentDictionaryEntries(DictionaryContent content) {
        this.presenters.forEach(p -> p.presentDictionaryEntries(content));
    }

    @Override
    public void presentDictionarySearchResult(DictionarySearchResult searchResult) {
        this.presenters.forEach(p -> p.presentDictionarySearchResult(searchResult));
    }

    @Override
    public void presentDefaultDictionary(ProvidedDictionaryDetails defaultDictionary) {
        this.presenters.forEach(p -> p.presentDefaultDictionary(defaultDictionary));
    }

    @Override
    public void presentDictionaryError(String error) {
        this.presenters.forEach(p -> p.presentDictionaryError(error));
    }

    @Override
    public void presentAvailableSolvers(List<SolverDescription> solverDescriptions) {
        this.presenters.forEach(p -> p.presentAvailableSolvers(solverDescriptions));
    }

    @Override
    public void presentSolverInitialisationState(SolverInitialisationState solverInitialisationState) {
        this.presenters.forEach(p -> p.presentSolverInitialisationState(solverInitialisationState));
    }

    @Override
    public void presentSolverProgress(SolverProgress progress) {
        this.presenters.forEach(p -> p.presentSolverProgress(progress));
    }

    @Override
    public void presentSolverResult(SolverResult result) {
        this.presenters.forEach(p -> p.presentSolverResult(result));
    }

    @Override
    public void presentSolverError(String error) {
        this.presenters.forEach(p -> p.presentSolverError(error));
    }

    @Override
    public void presentAvailablePuzzles(List<SavedPuzzle> puzzles) {
        this.presenters.forEach(p -> p.presentAvailablePuzzles(puzzles));
    }

    @Override
    public void presentLoadedPuzzle(SavedPuzzle puzzle) {
        this.presenters.forEach(p -> p.presentLoadedPuzzle(puzzle));
    }

    @Override
    public void presentPuzzleRepositoryError(String error) {
        this.presenters.forEach(p -> p.presentPuzzleRepositoryError(error));
    }

    @Override
    public void presentSavedPuzzle(SavedPuzzle puzzle) {
        this.presenters.forEach(p -> p.presentSavedPuzzle(puzzle));
    }

    @Override
    public void presentDeletedAllPuzzles() {
        this.presenters.forEach(PuzzlePresenter::presentDeletedAllPuzzles);
    }

    @Override
    public void presentDeletedPuzzle(long id) {
        this.presenters.forEach(p -> p.presentDeletedPuzzle(id));
    }

    @Override
    public void presentPuzzleDecoders(List<PuzzleCodecDetails> decoders) {
        this.presenters.forEach(p -> p.presentPuzzleDecoders(decoders));
    }

    @Override
    public void presentPuzzleImportError(String error) {
        this.presenters.forEach(p -> p.presentPuzzleImportError(error));
    }

    @Override
    public void presentPuzzleEncoders(List<PuzzleCodecDetails> encoders) {
        this.presenters.forEach(p -> p.presentPuzzleEncoders(encoders));
    }

    @Override
    public void presentPuzzleExportError(String error) {
        this.presenters.forEach(p -> p.presentPuzzleExportError(error));
    }

    @Override
    public void presentClueError(String error) {
        this.presenters.forEach(p -> p.presentClueError(error));
    }

    @Override
    public void presentClueProviders(List<ClueProviderDescription> clueProviderDescriptions) {
        this.presenters.forEach(p -> p.presentClueProviders(clueProviderDescriptions));
    }

    @Override
    public void presentClues(Map<String, String> clues) {
        this.presenters.forEach(p -> p.presentClues(clues));
    }
}

