/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.dictionary;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import re.belv.croiseur.common.dictionary.DictionaryProviderDetails;
import re.belv.croiseur.spi.dictionary.DictionaryProvider;
import re.belv.croiseur.spi.presenter.dictionary.DictionaryPresenter;

final class ListDictionaryProvidersUsecase {
    private final Collection<DictionaryProvider> dictionaryProviders;
    private final DictionaryPresenter presenter;

    ListDictionaryProvidersUsecase(Collection<DictionaryProvider> dictionaryProvidersArg, DictionaryPresenter presenterArg) {
        this.dictionaryProviders = dictionaryProvidersArg;
        this.presenter = presenterArg;
    }

    void process() {
        if (this.dictionaryProviders.isEmpty()) {
            this.presenter.presentDictionaryError("No dictionary found");
        } else {
            List<DictionaryProviderDetails> presentableProviders = this.dictionaryProviders.stream().map(DictionaryProvider::details).sorted(Comparator.comparing(DictionaryProviderDetails::name)).toList();
            this.presenter.presentDictionaryProviders(presentableProviders);
        }
    }
}

