/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.puzzle.exporter;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Optional;
import re.belv.croiseur.common.puzzle.Puzzle;
import re.belv.croiseur.common.puzzle.SavedPuzzle;
import re.belv.croiseur.impl.puzzle.persistence.shared.SafePuzzleRepository;
import re.belv.croiseur.spi.presenter.puzzle.PuzzlePresenter;
import re.belv.croiseur.spi.puzzle.codec.PuzzleEncoder;
import re.belv.croiseur.spi.puzzle.codec.PuzzleEncodingException;

final class ExportPuzzleUsecase {
    private final SafePuzzleRepository repository;
    private final Collection<PuzzleEncoder> encoders;
    private final PuzzlePresenter presenter;

    ExportPuzzleUsecase(SafePuzzleRepository repositoryArg, Collection<PuzzleEncoder> encodersArg, PuzzlePresenter presenterArg) {
        this.repository = repositoryArg;
        this.encoders = encodersArg;
        this.presenter = presenterArg;
    }

    public void process(long id, String format, OutputStream outputStream) {
        Optional<PuzzleEncoder> encoder = this.selectEncoder(format);
        if (encoder.isEmpty()) {
            this.presenter.presentPuzzleExportError("No suitable encoder found for format '" + format + "'");
            return;
        }
        Optional<Puzzle> puzzle = this.repository.query(id).map(SavedPuzzle::data);
        if (puzzle.isEmpty()) {
            this.presenter.presentPuzzleRepositoryError("Puzzle with id " + id + " not found.");
            return;
        }
        try {
            encoder.get().encode(puzzle.get(), outputStream);
        }
        catch (PuzzleEncodingException e) {
            this.presenter.presentPuzzleExportError("Failed to export puzzle: " + e.getMessage());
        }
    }

    private Optional<PuzzleEncoder> selectEncoder(String format) {
        return this.encoders.stream().filter(encoder -> encoder.details().supportedFormats().contains(format)).findFirst();
    }
}

