/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.puzzle.persistence;

import re.belv.croiseur.api.puzzle.persistence.PuzzlePatch;
import re.belv.croiseur.api.puzzle.persistence.PuzzlePersistenceService;
import re.belv.croiseur.common.puzzle.ChangedPuzzle;
import re.belv.croiseur.common.puzzle.Puzzle;
import re.belv.croiseur.impl.puzzle.persistence.DeleteAllPuzzlesUsecase;
import re.belv.croiseur.impl.puzzle.persistence.DeletePuzzleUsecase;
import re.belv.croiseur.impl.puzzle.persistence.ListPuzzlesUsecase;
import re.belv.croiseur.impl.puzzle.persistence.LoadPuzzleUsecase;
import re.belv.croiseur.impl.puzzle.persistence.PatchAndSavePuzzleUsecase;
import re.belv.croiseur.impl.puzzle.persistence.SaveChangedPuzzleUsecase;
import re.belv.croiseur.impl.puzzle.persistence.SaveNewPuzzleUsecase;
import re.belv.croiseur.impl.puzzle.persistence.shared.SafePuzzleRepository;
import re.belv.croiseur.spi.presenter.puzzle.PuzzlePresenter;

public final class PuzzlePersistenceServiceImpl
implements PuzzlePersistenceService {
    private final ListPuzzlesUsecase listPuzzlesUsecase;
    private final DeletePuzzleUsecase deletePuzzleUsecase;
    private final DeleteAllPuzzlesUsecase deleteAllPuzzlesUsecase;
    private final LoadPuzzleUsecase loadPuzzleUsecase;
    private final SaveNewPuzzleUsecase saveNewPuzzleUsecase;
    private final SaveChangedPuzzleUsecase saveChangedPuzzleUsecase;
    private final PatchAndSavePuzzleUsecase patchAndSavePuzzleUsecase;

    public PuzzlePersistenceServiceImpl(SafePuzzleRepository repository, PuzzlePresenter presenter) {
        this.listPuzzlesUsecase = new ListPuzzlesUsecase(repository, presenter);
        this.deletePuzzleUsecase = new DeletePuzzleUsecase(repository);
        this.deleteAllPuzzlesUsecase = new DeleteAllPuzzlesUsecase(repository);
        this.loadPuzzleUsecase = new LoadPuzzleUsecase(repository, presenter);
        this.saveNewPuzzleUsecase = new SaveNewPuzzleUsecase(repository);
        this.saveChangedPuzzleUsecase = new SaveChangedPuzzleUsecase(repository);
        this.patchAndSavePuzzleUsecase = new PatchAndSavePuzzleUsecase(repository, presenter);
    }

    @Override
    public void list() {
        this.listPuzzlesUsecase.process();
    }

    @Override
    public void delete(long puzzleId) {
        this.deletePuzzleUsecase.process(puzzleId);
    }

    @Override
    public void deleteAll() {
        this.deleteAllPuzzlesUsecase.process();
    }

    @Override
    public void load(long puzzleId) {
        this.loadPuzzleUsecase.process(puzzleId);
    }

    @Override
    public void save(Puzzle puzzle) {
        this.saveNewPuzzleUsecase.process(puzzle);
    }

    @Override
    public void save(ChangedPuzzle puzzle) {
        this.saveChangedPuzzleUsecase.process(puzzle);
    }

    @Override
    public void save(long id, PuzzlePatch patch) {
        this.patchAndSavePuzzleUsecase.process(id, patch);
    }
}

