/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.controller.clue;

import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.Task;
import re.belv.croiseur.api.clue.ClueService;
import re.belv.croiseur.gui.controller.clue.GetClueTask;
import re.belv.croiseur.gui.controller.clue.ListClueProviderTask;
import re.belv.croiseur.gui.view.model.CluesViewModel;
import re.belv.croiseur.gui.view.model.CrosswordGridViewModel;

public final class ClueController {
    private static final Logger LOGGER = Logger.getLogger(ClueController.class.getName());
    private final CluesViewModel cluesViewModel;
    private final CrosswordGridViewModel crosswordGridViewModel;
    private final ClueService clueService;
    private final Executor executor;

    public ClueController(CluesViewModel cluesViewModelArg, CrosswordGridViewModel crosswordGridViewModelArg, ClueService clueServiceArg, Executor executorArg) {
        this.cluesViewModel = cluesViewModelArg;
        this.crosswordGridViewModel = crosswordGridViewModelArg;
        this.clueService = clueServiceArg;
        this.executor = executorArg;
    }

    public void listClueProviders() {
        this.execute(new ListClueProviderTask(this.cluesViewModel, this.clueService));
    }

    public void getClueForCurrentSlot() {
        this.execute(new GetClueTask(this.cluesViewModel, this.crosswordGridViewModel, this.clueService));
    }

    private void execute(Task<Void> task) {
        task.setOnFailed(event -> LOGGER.log(Level.WARNING, "Clue task failed.", task.getException()));
        this.executor.execute((Runnable)task);
    }
}

