/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.controller.dictionary;

import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.Task;
import re.belv.croiseur.api.dictionary.DictionaryService;
import re.belv.croiseur.gui.controller.dictionary.ListDictionariesTask;
import re.belv.croiseur.gui.controller.dictionary.ListDictionaryEntriesTask;
import re.belv.croiseur.gui.view.model.DictionaryViewModel;

public final class DictionaryController {
    private static final Logger LOGGER = Logger.getLogger(DictionaryController.class.getName());
    private final DictionaryService dictionaryService;
    private final Executor executor;

    public DictionaryController(DictionaryService dictionaryServiceArg, Executor executorArg) {
        this.dictionaryService = dictionaryServiceArg;
        this.executor = executorArg;
    }

    public void listDictionaryEntries(DictionaryViewModel dictionaryViewModel) {
        this.execute(new ListDictionaryEntriesTask(dictionaryViewModel, this.dictionaryService));
    }

    public void listDictionaries() {
        this.execute(new ListDictionariesTask(this.dictionaryService));
    }

    private void execute(Task<Void> task) {
        task.setOnFailed(event -> LOGGER.log(Level.WARNING, "Dictionary task failed.", task.getException()));
        this.executor.execute((Runnable)task);
    }
}

