/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.controller.puzzle;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import re.belv.croiseur.api.puzzle.persistence.PuzzlePersistenceService;
import re.belv.croiseur.common.puzzle.ChangedPuzzle;
import re.belv.croiseur.common.puzzle.GridPosition;
import re.belv.croiseur.common.puzzle.Puzzle;
import re.belv.croiseur.common.puzzle.PuzzleClues;
import re.belv.croiseur.common.puzzle.PuzzleDetails;
import re.belv.croiseur.common.puzzle.PuzzleGrid;
import re.belv.croiseur.common.puzzle.SavedPuzzle;
import re.belv.croiseur.gui.view.model.ClueViewModel;
import re.belv.croiseur.gui.view.model.CluesViewModel;
import re.belv.croiseur.gui.view.model.CrosswordGridViewModel;
import re.belv.croiseur.gui.view.model.GridCoord;
import re.belv.croiseur.gui.view.model.PuzzleDetailsViewModel;
import re.belv.croiseur.gui.view.model.PuzzleEditionViewModel;

final class SavePuzzleTask
extends Task<Void> {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
    private final Runnable task;

    SavePuzzleTask(PuzzleEditionViewModel puzzleEditionViewModel, PuzzlePersistenceService puzzlePersistenceService) {
        this.task = SavePuzzleTask.buildTask(puzzleEditionViewModel, puzzlePersistenceService);
        puzzleEditionViewModel.savingInProgressProperty().bind((ObservableValue)this.runningProperty());
    }

    private static Runnable buildTask(PuzzleEditionViewModel puzzleEditionViewModel, PuzzlePersistenceService puzzlePersistenceService) {
        Runnable task = puzzleEditionViewModel.puzzleDetailsViewModel().id() != null ? SavePuzzleTask.newUpdateTaskFrom(puzzleEditionViewModel, puzzlePersistenceService) : SavePuzzleTask.newCreationTaskFrom(puzzleEditionViewModel, puzzlePersistenceService);
        return task;
    }

    private static Runnable newCreationTaskFrom(PuzzleEditionViewModel puzzleEditionViewModel, PuzzlePersistenceService puzzlePersistenceService) {
        PuzzleDetails details = SavePuzzleTask.convertToDomain(puzzleEditionViewModel.puzzleDetailsViewModel());
        PuzzleGrid grid = SavePuzzleTask.convertToDomain(puzzleEditionViewModel.crosswordGridViewModel());
        PuzzleClues clues = SavePuzzleTask.convertToDomain(puzzleEditionViewModel.cluesViewModel());
        Puzzle puzzle = new Puzzle(details, grid, clues);
        return () -> puzzlePersistenceService.save(puzzle);
    }

    private static Runnable newUpdateTaskFrom(PuzzleEditionViewModel puzzleEditionViewModel, PuzzlePersistenceService puzzlePersistenceService) {
        PuzzleDetailsViewModel puzzleDetailsViewModel = puzzleEditionViewModel.puzzleDetailsViewModel();
        PuzzleDetails details = SavePuzzleTask.convertToDomain(puzzleDetailsViewModel);
        long id = puzzleDetailsViewModel.id();
        int revision = puzzleDetailsViewModel.revision();
        PuzzleGrid currentGrid = SavePuzzleTask.convertToDomain(puzzleEditionViewModel.crosswordGridViewModel());
        PuzzleClues clues = SavePuzzleTask.convertToDomain(puzzleEditionViewModel.cluesViewModel());
        Puzzle puzzle = new Puzzle(details, currentGrid, clues);
        ChangedPuzzle changedPuzzle = new SavedPuzzle(id, puzzle, revision).asChangedPuzzle();
        return () -> puzzlePersistenceService.save(changedPuzzle);
    }

    private static PuzzleDetails convertToDomain(PuzzleDetailsViewModel puzzleDetailsViewModel) {
        Optional<Object> optDate;
        String viewModelDate = puzzleDetailsViewModel.date();
        if (viewModelDate.isEmpty()) {
            optDate = Optional.empty();
        } else {
            LocalDate date = LocalDate.parse(viewModelDate, DATE_FORMATTER);
            optDate = Optional.of(date);
        }
        return new PuzzleDetails(puzzleDetailsViewModel.title(), puzzleDetailsViewModel.author(), puzzleDetailsViewModel.editor(), puzzleDetailsViewModel.copyright(), optDate);
    }

    private static PuzzleGrid convertToDomain(CrosswordGridViewModel crosswordGridViewModel) {
        PuzzleGrid.Builder builder = new PuzzleGrid.Builder();
        builder.height(crosswordGridViewModel.rowCount());
        builder.width(crosswordGridViewModel.columnCount());
        crosswordGridViewModel.boxesProperty().forEach((gridCoord, box) -> {
            if (box.isShaded()) {
                builder.shade(SavePuzzleTask.convertToDomain(gridCoord));
            } else {
                String content = box.userContent();
                if (!content.isEmpty()) {
                    builder.fill(SavePuzzleTask.convertToDomain(gridCoord), Character.valueOf(content.charAt(0)));
                }
            }
        });
        return builder.build();
    }

    private static PuzzleClues convertToDomain(CluesViewModel cluesViewModel) {
        List<String> acrossClues = SavePuzzleTask.convertToDomain((List<ClueViewModel>)cluesViewModel.acrossCluesProperty());
        List<String> downClues = SavePuzzleTask.convertToDomain((List<ClueViewModel>)cluesViewModel.downCluesProperty());
        return new PuzzleClues(acrossClues, downClues);
    }

    private static List<String> convertToDomain(List<ClueViewModel> clueViewModels) {
        return clueViewModels.stream().map(ClueViewModel::userContent).toList();
    }

    private static GridPosition convertToDomain(GridCoord coord) {
        return new GridPosition(coord.column(), coord.row());
    }

    protected Void call() {
        this.task.run();
        return null;
    }
}

