/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import re.belv.croiseur.common.dictionary.DictionaryProviderDetails;
import re.belv.croiseur.dictionary.common.DictionaryPath;
import re.belv.croiseur.dictionary.common.util.Lazy;
import re.belv.croiseur.dictionary.hunspell.plugin.HunspellDictionary;
import re.belv.croiseur.spi.dictionary.Dictionary;
import re.belv.croiseur.spi.dictionary.DictionaryProvider;

public final class HunspellDictionaryProvider
implements DictionaryProvider {
    private final DictionaryProviderDetails details = new DictionaryProviderDetails("Local Hunspell Provider", "Provides access to local dictionaries in the Hunspell format.");
    private final Lazy<Collection<Dictionary>> dictionaries = Lazy.of(() -> HunspellDictionaryProvider.dictionaryFiles().map(HunspellDictionary::new).toList());

    private static Stream<URL> dictionaryFiles() {
        return DictionaryPath.getDefault().list().stream().filter(f -> f.getName().endsWith(".dic")).map(HunspellDictionaryProvider::urlFrom).filter(Objects::nonNull);
    }

    private static URL urlFrom(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public DictionaryProviderDetails details() {
        return this.details;
    }

    public Collection<Dictionary> get() {
        return (Collection)this.dictionaries.get();
    }
}

