/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.txt.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import re.belv.croiseur.common.dictionary.DictionaryDetails;
import re.belv.croiseur.dictionary.common.StringFilters;
import re.belv.croiseur.dictionary.common.StringTransformers;
import re.belv.croiseur.dictionary.common.util.Lazy;
import re.belv.croiseur.spi.dictionary.Dictionary;

final class TxtDictionary
implements Dictionary {
    private static final Logger LOGGER = Logger.getLogger(TxtDictionary.class.getName());
    private final Lazy<DictionaryDetails> details = Lazy.of(() -> TxtDictionary.readDetails(file));
    private final Lazy<Set<String>> words = Lazy.of(() -> TxtDictionary.readWords(file));

    TxtDictionary(File file) {
    }

    private static Set<String> readWords(File file) {
        Set set;
        block8: {
            Stream<String> lines = Files.lines(file.toPath());
            try {
                set = lines.filter(StringFilters.notEmpty()).map(StringTransformers.toAcceptableCrosswordEntry()).collect(Collectors.toCollection(LinkedHashSet::new));
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e, () -> "Failed to read dictionary words");
                    return Collections.emptySet();
                }
            }
            lines.close();
        }
        return set;
    }

    private static DictionaryDetails readDetails(File file) {
        DictionaryDetails dictionaryDetails;
        String propertiesPath = file.getPath() + ".properties";
        Properties properties = new Properties();
        FileInputStream fis = new FileInputStream(propertiesPath);
        try {
            properties.load(fis);
            Locale locale = Locale.forLanguageTag(properties.getProperty("locale", "en"));
            String name = properties.getProperty("name");
            String description = properties.getProperty("description");
            dictionaryDetails = new DictionaryDetails(name, locale, description);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e, () -> "Failed to read dictionary details");
                return DictionaryDetails.unknown();
            }
        }
        ((InputStream)fis).close();
        return dictionaryDetails;
    }

    public DictionaryDetails details() {
        return (DictionaryDetails)this.details.get();
    }

    public Set<String> words() {
        return (Set)this.words.get();
    }
}

