/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.txt.plugin;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Stream;
import re.belv.croiseur.common.dictionary.DictionaryProviderDetails;
import re.belv.croiseur.dictionary.common.DictionaryPath;
import re.belv.croiseur.dictionary.common.util.Lazy;
import re.belv.croiseur.dictionary.txt.plugin.TxtDictionary;
import re.belv.croiseur.spi.dictionary.Dictionary;
import re.belv.croiseur.spi.dictionary.DictionaryProvider;

public final class TxtDictionaryProvider
implements DictionaryProvider {
    private final DictionaryProviderDetails details = new DictionaryProviderDetails("Local Text Provider", "Provides access to local dictionaries in a simple text format.");
    private final Lazy<Collection<Dictionary>> dictionaries = Lazy.of(() -> TxtDictionaryProvider.dictionaryFiles().map(TxtDictionary::new).toList());

    private static Stream<File> dictionaryFiles() {
        return DictionaryPath.getDefault().list().stream().filter(f -> f.getName().endsWith(".txt") && Files.exists(Path.of(f.getPath() + ".properties", new String[0]), new LinkOption[0]));
    }

    public DictionaryProviderDetails details() {
        return this.details;
    }

    public Collection<Dictionary> get() {
        return (Collection)this.dictionaries.get();
    }
}

