/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.controller.solver;

import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import javafx.beans.property.ReadOnlyMapProperty;
import re.belv.croiseur.api.dictionary.DictionaryIdentifier;
import re.belv.croiseur.api.solver.SolveRequest;
import re.belv.croiseur.common.puzzle.GridPosition;
import re.belv.croiseur.common.puzzle.PuzzleGrid;
import re.belv.croiseur.gui.view.model.CrosswordGridViewModel;
import re.belv.croiseur.gui.view.model.DictionariesViewModel;
import re.belv.croiseur.gui.view.model.GridCoord;
import re.belv.croiseur.gui.view.model.SolverConfigurationViewModel;

final class SolveRequestImpl
implements SolveRequest {
    private final PuzzleGrid puzzle;
    private final Collection<DictionaryIdentifier> dictionaries;
    private final String selectedSolver;
    private final Random random;
    private final boolean fillCluesOnSuccess;

    SolveRequestImpl(CrosswordGridViewModel crosswordGridViewModel, DictionariesViewModel dictionariesViewModel, SolverConfigurationViewModel solverConfigurationViewModel, Random randomArg) {
        PuzzleGrid.Builder pdb = new PuzzleGrid.Builder();
        ReadOnlyMapProperty boxes = crosswordGridViewModel.boxesProperty();
        boxes.forEach((coord, box) -> {
            if (box.isShaded()) {
                pdb.shade(SolveRequestImpl.gridPositionFrom(coord));
            } else if (!box.userContent().isEmpty()) {
                pdb.fill(SolveRequestImpl.gridPositionFrom(coord), Character.valueOf(box.userContent().charAt(0)));
            }
        });
        pdb.width(crosswordGridViewModel.columnCount());
        pdb.height(crosswordGridViewModel.rowCount());
        this.puzzle = pdb.build();
        this.dictionaries = dictionariesViewModel.selectedDictionariesProperty().stream().map(entry -> new DictionaryIdentifier(entry.provider(), entry.name())).toList();
        this.selectedSolver = solverConfigurationViewModel.selectedSolver();
        this.random = randomArg;
        this.fillCluesOnSuccess = solverConfigurationViewModel.fillCluesOnSuccess();
    }

    public PuzzleGrid grid() {
        return this.puzzle;
    }

    public boolean savePuzzle() {
        return false;
    }

    public Collection<DictionaryIdentifier> dictionaries() {
        return this.dictionaries;
    }

    public Optional<Random> dictionariesShuffle() {
        return Optional.of(this.random);
    }

    public Optional<String> solver() {
        return Optional.ofNullable(this.selectedSolver);
    }

    public SolveRequest.SolverProgressNotificationMethod progress() {
        return SolveRequest.SolverProgressNotificationMethod.PERIODICAL;
    }

    public boolean withClues() {
        return this.fillCluesOnSuccess;
    }

    private static GridPosition gridPositionFrom(GridCoord coord) {
        return new GridPosition(coord.column(), coord.row());
    }
}

