/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.controller.solver;

import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import re.belv.croiseur.api.solver.SolverService;
import re.belv.croiseur.gui.controller.solver.ListSolversTask;
import re.belv.croiseur.gui.controller.solver.SolveTask;
import re.belv.croiseur.gui.view.model.ApplicationViewModel;

public final class SolverController {
    private static final Logger LOGGER = Logger.getLogger(SolverController.class.getName());
    private static final Random RANDOM = new Random(0L);
    private final SolverService solverService;
    private final Executor executor;
    private final Service<Void> solver;

    public SolverController(final ApplicationViewModel applicationViewModel, SolverService solverServiceArg, Executor executorArg) {
        this.executor = executorArg;
        this.solverService = solverServiceArg;
        this.solver = new Service<Void>(this){
            final /* synthetic */ SolverController this$0;
            {
                SolverController solverController = this$0;
                Objects.requireNonNull(solverController);
                this.this$0 = solverController;
            }

            protected Task<Void> createTask() {
                return new SolveTask(applicationViewModel.crosswordGridViewModel(), applicationViewModel.dictionaryViewModel(), applicationViewModel.solverConfigurationViewModel(), this.this$0.solverService, RANDOM);
            }
        };
        this.solver.setExecutor(this.executor);
        this.solver.setOnReady(e -> LOGGER.info("Solver ready"));
        this.solver.setOnRunning(e -> LOGGER.info("Solving"));
        this.solver.setOnCancelled(e -> LOGGER.info("Solver cancelled"));
        this.solver.setOnSucceeded(e -> LOGGER.info("Solver finished"));
        this.solver.setOnFailed(e -> LOGGER.log(Level.WARNING, "Solver failed", e.getSource().getException()));
        applicationViewModel.solverRunning().bind((ObservableValue)this.solver.runningProperty());
        applicationViewModel.solverRunning().addListener((observable, oldValue, newValue) -> applicationViewModel.clueServiceIsRunning().set(newValue.booleanValue()));
    }

    public void startSolver() {
        if (this.solver.getState() != Worker.State.READY) {
            this.stopSolver();
        }
        this.solver.start();
    }

    public void stopSolver() {
        this.solver.cancel();
        this.solver.reset();
    }

    public void listSolvers() {
        ListSolversTask listSolversTask = new ListSolversTask(this.solverService);
        listSolversTask.setOnFailed(e -> LOGGER.log(Level.WARNING, "Failed to list solvers", e.getSource().getException()));
        this.executor.execute((Runnable)((Object)listSolversTask));
    }
}

