/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.sat;

import java.math.BigInteger;
import java.util.List;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.GateTranslator;
import re.belv.croiseur.solver.sat.Alphabet;
import re.belv.croiseur.solver.sat.Grid;
import re.belv.croiseur.solver.sat.Pos;
import re.belv.croiseur.solver.sat.Slot;
import re.belv.croiseur.solver.sat.Variables;

final class Constraints {
    private static final int CELL_LITERALS_BUFFER_LENGTH = 20;
    private final Grid grid;
    private final String[] words;
    private final Variables variables;

    Constraints(Grid gridArg, String[] wordsArg, Variables variablesArg) {
        this.grid = gridArg;
        this.words = wordsArg;
        this.variables = variablesArg;
    }

    void addOneLetterOrBlockPerCellClausesTo(IPBSolver solver) throws ContradictionException, InterruptedException {
        VecInt literalsBuffer = new VecInt(Variables.CELL_VALUE_COUNT);
        for (int row = 0; row < this.grid.rowCount(); ++row) {
            for (int column = 0; column < this.grid.columnCount(); ++column) {
                Constraints.checkForInterruption();
                for (int letterIndex = 0; letterIndex < Alphabet.letterCount(); ++letterIndex) {
                    int letterVariable = this.variables.representingCell(row, column, letterIndex);
                    literalsBuffer.push(letterVariable);
                }
                int blockVariable = this.variables.representingCell(row, column, Variables.BLOCK_INDEX);
                literalsBuffer.push(blockVariable);
                this.addExactlyOne(solver, (IVecInt)literalsBuffer);
                literalsBuffer.clear();
            }
        }
    }

    void addOneWordPerSlotClausesTo(IPBSolver solver) throws ContradictionException, InterruptedException {
        GateTranslator gator = new GateTranslator((ISolver)solver);
        VecInt slotLiteralsBuffer = new VecInt(this.words.length);
        VecInt cellLiteralsBuffer = new VecInt(20);
        for (Slot slot : this.grid.slots()) {
            for (int wordIndex = 0; wordIndex < this.words.length; ++wordIndex) {
                Constraints.checkForInterruption();
                String word = this.words[wordIndex];
                if (word.length() != slot.length()) continue;
                int slotVariable = this.variables.representingSlot(slot.index(), wordIndex);
                slotLiteralsBuffer.push(slotVariable);
                this.fillCellLiteralsConjunction((IVecInt)cellLiteralsBuffer, slot, word);
                gator.and(slotVariable, (IVecInt)cellLiteralsBuffer);
                cellLiteralsBuffer.clear();
            }
            this.addExactlyOne(solver, (IVecInt)slotLiteralsBuffer);
            slotLiteralsBuffer.clear();
        }
    }

    private void fillCellLiteralsConjunction(IVecInt cellLiterals, Slot slot, String word) {
        List<Pos> slotPositions = slot.positions();
        int wordLength = word.length();
        for (int i = 0; i < wordLength; ++i) {
            Pos slotPos = slotPositions.get(i);
            char letter = word.charAt(i);
            int letterIndex = Alphabet.letterIndex(letter);
            if (letterIndex < 0) {
                throw new IllegalStateException("Unsupported character: " + letter);
            }
            int cellVar = this.variables.representingCell(slotPos.row(), slotPos.column(), letterIndex);
            cellLiterals.push(cellVar);
        }
    }

    private void addExactlyOne(IPBSolver solver, IVecInt literals) throws ContradictionException {
        Vec coefficients = new Vec(literals.size(), (Object)BigInteger.ONE);
        solver.addExactly(literals, (IVec)coefficients, BigInteger.ONE);
    }

    IVecInt inputGridConstraintsAreSatisfied() {
        VecInt literals = new VecInt(this.grid.rowCount() * this.grid.columnCount());
        for (int row = 0; row < this.grid.rowCount(); ++row) {
            for (int column = 0; column < this.grid.columnCount(); ++column) {
                int blockVariable;
                char prefilledLetter = this.grid.letterAt(row, column);
                if (prefilledLetter == '.') {
                    blockVariable = this.variables.representingCell(row, column, Variables.BLOCK_INDEX);
                    literals.push(-blockVariable);
                    continue;
                }
                if (prefilledLetter == '#') {
                    blockVariable = this.variables.representingCell(row, column, Variables.BLOCK_INDEX);
                    literals.push(blockVariable);
                    continue;
                }
                int letterIndex = Alphabet.letterIndex(prefilledLetter);
                int letterVariable = this.variables.representingCell(row, column, letterIndex);
                literals.push(letterVariable);
            }
        }
        return literals;
    }

    private static void checkForInterruption() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted while adding constraints");
        }
    }
}

