/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.sat;

import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import re.belv.croiseur.solver.sat.Pos;

final class Slot {
    static final int MIN_LENGTH = 2;
    private final int index;
    private final int start;
    private final int end;
    private final int offset;
    private final boolean isDown;

    Slot(int indexArg, int startArg, int endArg, int offsetArg, boolean isDownArg) {
        if (endArg - startArg < 2) {
            throw new IllegalArgumentException("Invalid slot length: Slot must be at least 2 cells-long, given slot length is " + (endArg - startArg));
        }
        this.index = indexArg;
        this.start = startArg;
        this.end = endArg;
        this.offset = offsetArg;
        this.isDown = isDownArg;
    }

    static Slot across(int index, int startColumn, int endColumn, int row) {
        return new Slot(index, startColumn, endColumn, row, false);
    }

    static Slot down(int index, int startRow, int endRow, int column) {
        return new Slot(index, startRow, endRow, column, true);
    }

    List<Pos> positions() {
        return IntStream.range(this.start, this.end).mapToObj(i -> this.isDown ? new Pos(this.offset, i) : new Pos(i, this.offset)).toList();
    }

    int length() {
        return this.end - this.start;
    }

    int index() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Slot)) {
            return false;
        }
        Slot slot = (Slot)o;
        return this.index == slot.index && this.start == slot.start && this.end == slot.end && this.offset == slot.offset && this.isDown == slot.isDown;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.start, this.end, this.offset, this.isDown);
    }

    public String toString() {
        return "Slot{index=" + this.index + ", start=" + this.start + ", end=" + this.end + ", offset=" + this.offset + ", isDown=" + this.isDown + "}";
    }
}

