/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.parser.aff;

import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Pattern;

enum AffItemKind {
    AFFIX_HEADER("(PFX|SFX) +[^ /]+ +[YN] +[0-9]+"),
    AFFIX_RULE("^(PFX|SFX) +[^ /]+ +[^ /]+ +[^ /]+(/[^ /]+)? +[^ /]+ *$"),
    BLANK("^[ ]*$"),
    COMMENT("^#.*$"),
    COMPOUNDING_COMPOUNDBEGIN("^COMPOUNDBEGIN [^ ]+$"),
    COMPOUNDING_BREAK_HEADER("^BREAK [0-9]+$"),
    COMPOUNDING_BREAK("^BREAK [^ ]+$"),
    COMPOUNDING_CHECK_CASE("^CHECKCOMPOUNDCASE$"),
    COMPOUNDING_COMPOUNDFLAG("^COMPOUNDFLAG [^ ]+$"),
    COMPOUNDING_COMPOUNDEND("^COMPOUNDEND [^ ]+$"),
    COMPOUNDING_COMPOUNDMIDDLE("^COMPOUNDMIDDLE [^ ]+$"),
    COMPOUNDING_MIN("^COMPOUNDMIN [0-9]+$"),
    COMPOUNGING_ONLY_IN("^ONLYINCOMPOUND [^ ]+$"),
    COMPOUNDPERMITFLAG("^COMPOUNDPERMITFLAG [^ ]+$"),
    COUMPONDING_RULE("^COMPOUNDRULE [^ ]+$"),
    GENERAL_COMPLEX_PREFIXES("^COMPLEXPREFIXES$"),
    GENERAL_ENCODING("^SET (UTF-8|ISO-?8859-1|ISO-?8859-10|ISO-?8859-13|ISO-?8859-15|KOI8-R|KOI8-U|microsoft-cp1251|ISCII-DEVANAGARI)$"),
    GENERAL_FLAG_TYPE("^FLAG (UTF-8|long|num)$"),
    GENERAL_LANG("^LANG [a-z]{2}(_[A-Z]{2})?$"),
    OTHERS_CHECKSHARPS("^CHECKSHARPS$"),
    OTHERS_CIRCUMFIX("^CIRCUMFIX [^ ]+$"),
    OTHERS_FORBIDDEN_WORD("^FORBIDDENWORD [^ ]+$"),
    OTHERS_FULL_STRIP("^FULLSTRIP$"),
    OTHERS_INPUT_CONVERSION_TABLE_HEADER("^ICONV [0-9]+$"),
    OTHERS_INPUT_CONVERSION_TABLE_ENTRY("^ICONV [^ ]+ [^ ]+$"),
    OTHERS_KEEP_CASE("^KEEPCASE [^ ]+$"),
    OTHERS_NEED_AFFIX("^NEEDAFFIX [^ ]+$"),
    OTHERS_OUTPUT_CONVERSION_TABLE_HEADER("^OCONV [0-9]+$"),
    OTHERS_OUTPUT_CONVERSION_TABLE_ENTRY("^OCONV [^ ]+ [^ ]+$"),
    OTHERS_WORD_CHARS("^WORDCHARS [^ ]+$"),
    SUGGESTION_KEY("^KEY [^ \\|]+(\\|[^ \\|]+)*"),
    SUGGESTION_RELATED_CHARACTERS_TABLE_ENTRY("^MAP [^ ]+$"),
    SUGGESTION_RELATED_CHARACTERS_TABLE_HEADER("^MAP [0-9]+$"),
    SUGGESTION_REPLACEMENT_TABLE_HEADER("^REP [0-9]+$"),
    SUGGESTION_REPLACEMENT_TABLE_ENTRY("^REP [^ ]+ [^ ]+$"),
    SUGGESTION_MAX_NGRAM("^MAXNGRAMSUGS [0-9]+$"),
    SUGGESTION_NO_SPLIT("^NOSPLITSUGS$"),
    SUGGESTION_NO_SUGGEST("^NOSUGGEST [^ ]+$"),
    SUGGESTION_TRY("^TRY [^ ]+$"),
    UNDOCUMENTED_HOME("^HOME .+$"),
    UNDOCUMENTED_NAME("^NAME .+$"),
    UNDOCUMENTED_VERSION("^VERSION .+$");

    private static final AffItemKind[] ALL_ITEM_KINDS;
    private final Pattern identificationPattern;

    private AffItemKind(String pattern) {
        this.identificationPattern = Pattern.compile(pattern);
    }

    static Optional<AffItemKind> identify(String line) {
        return Arrays.stream(ALL_ITEM_KINDS).filter(affItemKind -> affItemKind.matches(line)).findFirst();
    }

    private boolean matches(String line) {
        return this.identificationPattern.matcher(line).matches();
    }

    static {
        ALL_ITEM_KINDS = AffItemKind.values();
    }
}

