/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.parser.aff;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.AffixKind;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.AffixRule;
import re.belv.croiseur.dictionary.hunspell.codec.model.common.Flag;
import re.belv.croiseur.dictionary.hunspell.codec.parser.common.FlagType;

final class AffixRuleParser {
    private static final Pattern PATTERN = Pattern.compile("^(?<kind>(PFX|SFX)) +(?<flag>[^ /]+) +(0|(?<strippingCharacters>[^ /]+)) +(?<affix>[^ /]+)(/(?<continuationClasses>[^ /]+))? +(\\.|(?<condition>[^ /]+)) *$");

    AffixRuleParser() {
    }

    static AffixRule parse(String line) {
        return AffixRuleParser.parse(line, FlagType.byDefault());
    }

    static AffixRule parse(String line, FlagType flagType) {
        Matcher matcher = PATTERN.matcher(line);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Not an affix rule: " + line);
        }
        AffixKind kind = AffixKind.valueOf(matcher.group("kind"));
        Flag flag = new Flag(matcher.group("flag"));
        Optional<String> strippingCharacters = Optional.ofNullable(matcher.group("strippingCharacters"));
        String affix = matcher.group("affix");
        Collection<Flag> continuationClasses = AffixRuleParser.parseContinuationClasses(matcher, flagType);
        Optional<String> condition = Optional.ofNullable(matcher.group("condition"));
        return new AffixRule(kind, flag, strippingCharacters, affix, continuationClasses, condition);
    }

    private static Collection<Flag> parseContinuationClasses(Matcher matcher, FlagType flagType) {
        return Optional.ofNullable(matcher.group("continuationClasses")).map(flagType::split).orElseGet(Collections::emptyList);
    }
}

