/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.parser.aff;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class EncodingParser {
    private static final Pattern PATTERN = Pattern.compile("^SET (UTF-8|ISO-?8859-1|ISO-?8859-10|ISO-?8859-13|ISO-?8859-15|KOI8-R|KOI8-U|microsoft-cp1251|ISCII-DEVANAGARI)$");

    private EncodingParser() {
    }

    static Charset parse(String line) {
        Matcher matcher = PATTERN.matcher(line);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Not a SET encoding option");
        }
        String encoding = EncodingParser.standardize(matcher.group(1));
        return Charset.forName(encoding);
    }

    private static String standardize(String name) {
        return switch (name) {
            case "microsoft-cp1251" -> "cp1251";
            case "ISCII-DEVANAGARI" -> "ISCII";
            default -> name;
        };
    }
}

