/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.parser.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import re.belv.croiseur.dictionary.hunspell.codec.model.common.Flag;

public enum FlagType {
    SINGLE_ASCII("[\\x00-\\xFF]"),
    LONG_ASCII("[\\x00-\\xFF]{2}"),
    NUMERICAL("[1-9][0-9]{0,4}"),
    UTF_8(".");

    private final Pattern pattern;

    private FlagType(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    public static FlagType byDefault() {
        return SINGLE_ASCII;
    }

    public Collection<Flag> split(String flags) {
        List<Flag> splitFlags;
        if (flags != null) {
            splitFlags = new ArrayList();
            Matcher matcher = this.pattern.matcher(flags);
            while (matcher.find()) {
                Flag flag = new Flag(matcher.group());
                splitFlags.add(flag);
            }
        } else {
            splitFlags = Collections.emptyList();
        }
        return splitFlags;
    }
}

