/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.parser.dic;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import re.belv.croiseur.dictionary.hunspell.codec.model.common.Flag;
import re.belv.croiseur.dictionary.hunspell.codec.model.dic.DicEntry;
import re.belv.croiseur.dictionary.hunspell.codec.parser.common.FlagType;
import re.belv.croiseur.dictionary.hunspell.codec.parser.dic.InvalidDicEntryException;

final class DicEntryParser {
    private static final Pattern PATTERN = Pattern.compile("^(?<forbidden>\\*)?(?<word>[^ /\t]+)(/(?<flags>[^ /\t]+))?([\t| ]+(?<morphology>.+))?[ \t]*$");

    private DicEntryParser() {
    }

    static DicEntry parse(String line) throws InvalidDicEntryException {
        return DicEntryParser.parse(line, FlagType.SINGLE_ASCII);
    }

    static DicEntry parse(String line, FlagType flagType) throws InvalidDicEntryException {
        Matcher matcher = PATTERN.matcher(line);
        if (!matcher.matches()) {
            throw new InvalidDicEntryException("Not a dic entry: " + line);
        }
        boolean isForbidden = matcher.group("forbidden") != null;
        String word = matcher.group("word");
        Collection<Flag> flags = flagType.split(matcher.group("flags"));
        return new DicEntry(isForbidden, word, flags);
    }
}

