/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.wordforms;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.AffixClass;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.AffixRule;
import re.belv.croiseur.dictionary.hunspell.codec.model.common.Flag;
import re.belv.croiseur.dictionary.hunspell.codec.model.dic.DicEntry;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.AffixClasses;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.AffixRuleApplicator;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.AffixRuleApplicators;

final class AffixClassApplicator
implements Function<DicEntry, Stream<String>> {
    private final AffixClass affixClass;
    private final AffixClasses affixClasses;
    private final Map<AffixRule, AffixRuleApplicator> affixApplicators;

    AffixClassApplicator(AffixClass affixClassArg, AffixClasses affixClassesArg) {
        this.affixClass = affixClassArg;
        this.affixClasses = affixClassesArg;
        this.affixApplicators = new HashMap<AffixRule, AffixRuleApplicator>();
    }

    @Override
    public Stream<String> apply(DicEntry entry) {
        return this.affixClass.rules().stream().mapMulti((rule, accumulator) -> this.applyRule((AffixRule)rule, entry, (Consumer<String>)accumulator));
    }

    private void applyRule(AffixRule affixRule, DicEntry entry, Consumer<String> accumulator) {
        Optional<String> optAffixedForm = this.applyAffixRule(affixRule, entry.word());
        if (optAffixedForm.isPresent()) {
            String affixedForm = optAffixedForm.get();
            accumulator.accept(affixedForm);
            this.applyCrossProductAffixRules(entry, affixedForm, accumulator);
            this.applyContinuationAffixRules(affixRule, affixedForm, accumulator);
        }
    }

    private void applyContinuationAffixRules(AffixRule affixRule, String affixedForm, Consumer<String> accumulator) {
        this.affixRulesOf(affixRule.continuationClasses()).flatMap(rule -> this.applyAffixRule((AffixRule)rule, affixedForm).stream()).forEach(accumulator);
    }

    private void applyCrossProductAffixRules(DicEntry entry, String affixedForm, Consumer<String> accumulator) {
        this.crossProductAffixRulesOf(entry).flatMap(rule -> this.applyAffixRule((AffixRule)rule, affixedForm).stream()).forEach(accumulator);
    }

    private AffixRuleApplicator applicatorOf(AffixRule affixRule) {
        return this.affixApplicators.computeIfAbsent(affixRule, rule -> AffixRuleApplicators.ofRule(affixRule));
    }

    private Optional<String> applyAffixRule(AffixRule affixRule, String word) {
        return (Optional)this.applicatorOf(affixRule).apply(word);
    }

    private Stream<AffixRule> affixRulesOf(Collection<Flag> flags) {
        return this.affixClasses.referencedBy(flags).flatMap(cls -> cls.rules().stream());
    }

    private Stream<AffixRule> crossProductAffixRulesOf(DicEntry entry) {
        Stream<AffixRule> crossProductAffixRules = this.affixClass.crossProduct() ? this.affixClasses.referencedBy(entry.flags()).filter(cls -> cls.crossProduct() && cls.kind() != this.affixClass.kind()).flatMap(cls -> cls.rules().stream()) : Stream.empty();
        return crossProductAffixRules;
    }
}

