/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.wordforms;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.Aff;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.AffixClass;
import re.belv.croiseur.dictionary.hunspell.codec.model.common.Flag;

final class AffixClasses
implements Iterable<AffixClass> {
    private final Map<Flag, AffixClass> affixClasses = new HashMap<Flag, AffixClass>();

    AffixClasses(Aff aff) {
        for (AffixClass affixClass : aff.affixClasses()) {
            this.affixClasses.put(affixClass.flag(), affixClass);
        }
    }

    Stream<AffixClass> referencedBy(Collection<Flag> flags) {
        return flags.stream().map(this.affixClasses::get).filter(Objects::nonNull);
    }

    @Override
    public Iterator<AffixClass> iterator() {
        return Collections.unmodifiableCollection(this.affixClasses.values()).iterator();
    }
}

