/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.wordforms;

import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import re.belv.croiseur.dictionary.hunspell.codec.model.common.Flag;
import re.belv.croiseur.dictionary.hunspell.codec.model.dic.DicEntry;
import re.belv.croiseur.dictionary.hunspell.codec.util.MoreCollections;
import re.belv.croiseur.dictionary.hunspell.codec.util.Pair;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.Affixer;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.BeginEndCompound;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.Compounder;

final class BeginEndCompounder
implements Compounder {
    private final Flag compoundFlag;
    private final Affixer affixer;

    BeginEndCompounder(Flag compoundFlagArg, Affixer affixerArg) {
        this.compoundFlag = compoundFlagArg;
        this.affixer = affixerArg;
    }

    @Override
    public Stream<String> apply(Collection<DicEntry> entries) {
        Set compoundableEntries = entries.stream().filter(entry -> entry.isFlaggedWith(this.compoundFlag)).collect(Collectors.toSet());
        return MoreCollections.pairs(compoundableEntries).stream().mapMulti((compoundParts, accumulator) -> {
            BeginEndCompound compound = this.compound((Pair<DicEntry, DicEntry>)compoundParts, (Consumer<String>)accumulator);
            this.applyAffixes(compound, (Consumer<String>)accumulator);
        });
    }

    private BeginEndCompound compound(Pair<DicEntry, DicEntry> compoundParts, Consumer<String> accumulator) {
        BeginEndCompound compound = new BeginEndCompound(compoundParts.left(), compoundParts.right());
        accumulator.accept(compound.word());
        return compound;
    }

    private void applyAffixes(BeginEndCompound compound, Consumer<String> accumulator) {
        this.affixer.apply(compound).forEach(accumulator);
    }
}

