/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.wordforms;

import java.util.Optional;
import java.util.regex.Pattern;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.AffixRule;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.AffixRuleApplicator;

final class SuffixRuleApplicator
implements AffixRuleApplicator {
    private final AffixRule rule;
    private final Optional<Pattern> conditionPattern;
    private final Optional<Pattern> strippingPattern;

    SuffixRuleApplicator(AffixRule aRule) {
        this.rule = SuffixRuleApplicator.validate(aRule);
        this.conditionPattern = SuffixRuleApplicator.compileConditionPattern(aRule);
        this.strippingPattern = SuffixRuleApplicator.compileStrippingPattern(aRule);
    }

    private static Optional<Pattern> compileConditionPattern(AffixRule rule) {
        return rule.condition().map(condition -> Pattern.compile(condition + "$"));
    }

    private static Optional<Pattern> compileStrippingPattern(AffixRule rule) {
        return rule.strippingCharacters().map(stripped -> Pattern.compile(stripped + "$"));
    }

    private static AffixRule validate(AffixRule rule) {
        if (!rule.isSuffix()) {
            throw new IllegalArgumentException(String.valueOf(rule) + " is not a suffix");
        }
        return rule;
    }

    @Override
    public Optional<String> apply(String stem) {
        return this.isApplicable(stem) ? Optional.of(this.strip(stem) + this.rule.affix()) : Optional.empty();
    }

    private boolean isApplicable(String stem) {
        return this.conditionPattern.map(p -> p.matcher(stem).find()).orElse(true);
    }

    private String strip(String stem) {
        return this.strippingPattern.map(p -> p.matcher(stem).replaceFirst("")).orElse(stem);
    }
}

