/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.wordforms;

import java.util.stream.Stream;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.Aff;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.ThreePartsCompoundFlags;
import re.belv.croiseur.dictionary.hunspell.codec.model.common.Flag;
import re.belv.croiseur.dictionary.hunspell.codec.model.dic.Dic;
import re.belv.croiseur.dictionary.hunspell.codec.model.dic.DicEntry;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.AffixClasses;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.Affixer;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.BeginEndCompounder;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.BeginMiddleEndCompounder;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.Compounder;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.WordFormGenerator;

final class WordFormGeneratorImpl
implements WordFormGenerator {
    private final Dic dic;
    private final Affixer affixer;
    private final Compounder beginEndCompounder;
    private final Compounder beginMiddleEndCompounder;

    WordFormGeneratorImpl(Aff affArg, Dic dicArg) {
        this.dic = dicArg;
        this.affixer = new Affixer(new AffixClasses(affArg));
        this.beginEndCompounder = affArg.compoundFlag().map(flag -> new BeginEndCompounder((Flag)flag, this.affixer)).orElse(dicEntries -> Stream.empty());
        this.beginMiddleEndCompounder = affArg.threePartsCompoundFlags().map(compoundBeginMiddleEndFlags -> new BeginMiddleEndCompounder((ThreePartsCompoundFlags)compoundBeginMiddleEndFlags, this.affixer)).orElse(dicEntries -> Stream.empty());
    }

    @Override
    public Stream<String> generate() {
        Stream<String> affixed = this.applyAffixes();
        Stream<String> compounded = this.applyCompounds();
        return Stream.concat(affixed, compounded);
    }

    private Stream<String> applyCompounds() {
        Stream beginEndCompounds = (Stream)this.beginEndCompounder.apply(this.dic.entries());
        Stream beginMiddleEndCompounds = (Stream)this.beginMiddleEndCompounder.apply(this.dic.entries());
        return Stream.concat(beginEndCompounds, beginMiddleEndCompounds);
    }

    private Stream<String> applyAffixes() {
        return this.dic.entries().stream().flatMap(entry -> {
            Stream<String> nonAffixedForm = Stream.of(entry.word());
            Stream<String> affixedForms = this.affixer.apply((DicEntry)entry);
            return Stream.concat(nonAffixedForm, affixedForms);
        });
    }
}

