/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.common;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public final class DictionaryPath {
    public static final String SYSTEM_PROPERTY = "re.belv.croiseur.dictionary.path";
    private final String path;

    private DictionaryPath(String pathArg) {
        this.path = Objects.requireNonNull(pathArg);
    }

    public static DictionaryPath getDefault() {
        return DictionaryPath.userSpecific().append(DictionaryPath.systemDefined()).append(DictionaryPath.relativeToJar());
    }

    public static DictionaryPath userSpecific() {
        String path = System.getProperty("user.home") + "/croiseur/dictionaries";
        return new DictionaryPath(path);
    }

    public static DictionaryPath systemDefined() {
        String path = System.getProperty(SYSTEM_PROPERTY, "");
        return new DictionaryPath(path);
    }

    public static DictionaryPath relativeToJar() {
        String path;
        URI codeLocation = DictionaryPath.codeLocation();
        if (codeLocation != null) {
            Path parentDir = Path.of(codeLocation).getParent();
            path = parentDir.resolve("dictionaries").toString();
        } else {
            path = "";
        }
        return new DictionaryPath(path);
    }

    private static URI codeLocation() {
        CodeSource codeSource = DictionaryPath.class.getProtectionDomain().getCodeSource();
        try {
            return codeSource != null ? codeSource.getLocation().toURI() : null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static DictionaryPath of(String path) {
        return new DictionaryPath(path);
    }

    public static DictionaryPath empty() {
        return new DictionaryPath("");
    }

    private static Stream<File> expandDirectory(File file) {
        File[] files = file.listFiles(File::isFile);
        return files != null ? Arrays.stream(files) : Stream.of(file);
    }

    public DictionaryPath append(DictionaryPath other) {
        return new DictionaryPath(this.path + File.pathSeparator + other.path);
    }

    public DictionaryPath prepend(DictionaryPath other) {
        return other.append(this);
    }

    public List<String> split() {
        return List.of(this.path.split(File.pathSeparator));
    }

    public List<File> list() {
        return this.split().stream().map(File::new).filter(f -> f.exists() && !Files.isSymbolicLink(f.toPath())).flatMap(DictionaryPath::expandDirectory).toList();
    }

    public String toString() {
        return "DictionaryPath{path='" + this.path + "'}";
    }
}

