/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view;

import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.Pane;
import re.belv.croiseur.gui.view.FxmlLoaderHelper;
import re.belv.croiseur.gui.view.SolveSplitMenuButton;
import re.belv.croiseur.gui.view.model.SolverItemViewModel;

public final class CrosswordEditorToolbar
extends ToolBar {
    private final BooleanProperty gridEditionButtonsDisableProperty = new SimpleBooleanProperty((Object)this, "gridEditionButtonsDisableProperty");
    @FXML
    private ToggleButton puzzleToggleButton;
    @FXML
    private Pane leftSeparator;
    @FXML
    private ToggleButton resizeGridButton;
    @FXML
    private Button addColumnButton;
    @FXML
    private Button addRowButton;
    @FXML
    private Button deleteColumnButton;
    @FXML
    private Button deleteGridButton;
    @FXML
    private Button deleteRowButton;
    @FXML
    private MenuButton clearGridMenuButton;
    @FXML
    private MenuItem clearGridLettersFilledBySolverMenuItem;
    @FXML
    private MenuItem clearGridAllLettersMenuItem;
    @FXML
    private MenuItem clearGridContentMenuItem;
    @FXML
    private SolveSplitMenuButton solveButton;
    @FXML
    private Button saveButton;
    @FXML
    private Pane rightSeparator;
    @FXML
    private ToggleButton dictionariesToggleButton;

    public CrosswordEditorToolbar() {
        FxmlLoaderHelper.load((Object)this, ResourceBundle.getBundle(((Object)((Object)this)).getClass().getName()));
    }

    @FXML
    private void initialize() {
        this.initializeResizeButtons();
        this.initializeNonResizeButtons();
        this.initializeEditionButtons();
    }

    private void initializeNonResizeButtons() {
        BooleanProperty resizeMode = this.resizeGridButton.selectedProperty();
        List.of(this.puzzleToggleButton, this.leftSeparator, this.clearGridMenuButton, this.solveButton, this.saveButton, this.dictionariesToggleButton, this.rightSeparator).forEach(button -> {
            button.visibleProperty().bind((ObservableValue)resizeMode.not());
            button.managedProperty().bind((ObservableValue)resizeMode.not());
        });
    }

    private void initializeResizeButtons() {
        BooleanProperty resizeMode = this.resizeGridButton.selectedProperty();
        List.of(this.addColumnButton, this.addRowButton, this.deleteColumnButton, this.deleteRowButton, this.deleteGridButton).forEach(button -> {
            button.visibleProperty().bind((ObservableValue)resizeMode);
            button.managedProperty().bind((ObservableValue)resizeMode);
        });
    }

    private void initializeEditionButtons() {
        List.of(this.addColumnButton, this.addRowButton, this.deleteColumnButton, this.deleteRowButton, this.deleteGridButton, this.saveButton, this.clearGridMenuButton, this.resizeGridButton).forEach(button -> button.disableProperty().bind((ObservableValue)this.gridEditionButtonsDisableProperty));
    }

    public BooleanProperty puzzleToggleButtonSelectedProperty() {
        return this.puzzleToggleButton.selectedProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onAddColumnActionButtonProperty() {
        return this.addColumnButton.onActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onAddRowActionButtonProperty() {
        return this.addRowButton.onActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onDeleteColumnActionButtonProperty() {
        return this.deleteColumnButton.onActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onDeleteRowActionButtonProperty() {
        return this.deleteRowButton.onActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onClearGridLettersFilledBySolverMenuItemActionProperty() {
        return this.clearGridLettersFilledBySolverMenuItem.onActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onClearGridAllLettersMenuItemActionProperty() {
        return this.clearGridAllLettersMenuItem.onActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onClearGridContentMenuItemActionProperty() {
        return this.clearGridContentMenuItem.onActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onDeleteGridActionProperty() {
        return this.deleteGridButton.onActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onSolveButtonActionProperty() {
        return this.solveButton.onActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onSaveButtonActionProperty() {
        return this.saveButton.onActionProperty();
    }

    public BooleanProperty dictionariesToggleButtonSelectedProperty() {
        return this.dictionariesToggleButton.selectedProperty();
    }

    public BooleanProperty resizeModeProperty() {
        return this.resizeGridButton.selectedProperty();
    }

    public BooleanProperty editionButtonsDisableProperty() {
        return this.gridEditionButtonsDisableProperty;
    }

    public BooleanProperty solveButtonDisableProperty() {
        return this.solveButton.disableProperty();
    }

    public StringProperty solveButtonTextProperty() {
        return this.solveButton.textProperty();
    }

    public ReadOnlyProperty<String> solveButtonSelectedSolverProperty() {
        return this.solveButton.selectedSolverProperty();
    }

    public ListProperty<SolverItemViewModel> solveButtonAvailableSolversProperty() {
        return this.solveButton.availableSolversProperty();
    }

    public ReadOnlyBooleanProperty fillClueOnSolverSuccessProperty() {
        return this.solveButton.getCluesOnSuccessProperty();
    }
}

