/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.NumberBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleMapProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import re.belv.croiseur.gui.view.CrosswordBoxTextField;
import re.belv.croiseur.gui.view.CrosswordGridPlaceholder;
import re.belv.croiseur.gui.view.FxmlLoaderHelper;
import re.belv.croiseur.gui.view.model.CrosswordBoxViewModel;
import re.belv.croiseur.gui.view.model.GridCoord;

public final class CrosswordGridPane
extends StackPane {
    private static final Comparator<Node> BOX_COMPARATOR = Comparator.comparingInt(GridPane::getRowIndex).thenComparingInt(GridPane::getColumnIndex);
    private final MapProperty<GridCoord, CrosswordBoxViewModel> boxModels = new SimpleMapProperty((Object)this, "boxModels", FXCollections.observableHashMap());
    private final Map<GridCoord, Node> boxNodes = new HashMap<GridCoord, Node>();
    private final ObjectProperty<GridCoord> currentBoxPosition = new SimpleObjectProperty((Object)this, "currentBoxPosition", null);
    private final BooleanProperty currentSlotVertical = new SimpleBooleanProperty((Object)this, "currentSlotVertical", false);
    @FXML
    private GridPane grid;
    @FXML
    private CrosswordGridPlaceholder placeholder;

    public CrosswordGridPane() {
        FxmlLoaderHelper.load((Object)this);
    }

    public MapProperty<GridCoord, CrosswordBoxViewModel> boxesProperty() {
        return this.boxModels;
    }

    public ObjectProperty<GridCoord> currentBoxPositionProperty() {
        return this.currentBoxPosition;
    }

    public BooleanProperty currentSlotVerticalProperty() {
        return this.currentSlotVertical;
    }

    @FXML
    private void initialize() {
        this.initializeGridConstraints();
        this.boxModels.addListener(this::onModelUpdate);
        this.grid.addEventFilter(InputEvent.ANY, (EventHandler)new SlotOrientationChanger(this));
        this.grid.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new ArrowKeyNavigator(this));
        this.grid.addEventHandler(KeyEvent.KEY_RELEASED, (EventHandler)new AutoMoveCurrentBox(this));
        this.placeholder.visibleProperty().bind((ObservableValue)this.boxModels.emptyProperty());
        this.placeholder.managedProperty().bind((ObservableValue)this.boxModels.emptyProperty());
        this.placeholder.wrappingWidthProperty().bind((ObservableValue)this.grid.widthProperty().subtract(10));
    }

    private void onModelUpdate(MapChangeListener.Change<? extends GridCoord, ? extends CrosswordBoxViewModel> change) {
        if (change.wasAdded()) {
            if (change.getValueRemoved() != null) {
                throw new UnsupportedOperationException("Replacing box models is not supported");
            }
            this.onBoxAdded((GridCoord)change.getKey(), (CrosswordBoxViewModel)change.getValueAdded());
        } else {
            this.onBoxRemoved((GridCoord)change.getKey());
        }
    }

    private void onBoxRemoved(GridCoord removedCoordinate) {
        this.removeBoxNode(removedCoordinate);
        this.maybeRemoveColumnConstraint(removedCoordinate);
        this.maybeRemoveRowConstraint(removedCoordinate);
        this.maybeClearConstraints();
    }

    private void removeBoxNode(GridCoord coordinate) {
        Node removedNode = this.boxNodes.remove(coordinate);
        this.grid.getChildren().remove((Object)removedNode);
    }

    private void maybeRemoveRowConstraint(GridCoord removedCoordinate) {
        if (this.boxNodes.keySet().stream().noneMatch(coord -> coord.row() >= removedCoordinate.row())) {
            this.grid.getRowConstraints().remove(removedCoordinate.row());
        }
    }

    private void maybeRemoveColumnConstraint(GridCoord removedCoordinate) {
        if (this.boxNodes.keySet().stream().noneMatch(coord -> coord.column() >= removedCoordinate.column())) {
            this.grid.getColumnConstraints().remove(removedCoordinate.column());
        }
    }

    private void maybeClearConstraints() {
        if (this.boxNodes.isEmpty()) {
            if (!this.grid.getRowConstraints().isEmpty()) {
                this.grid.getRowConstraints().clear();
            }
            if (!this.grid.getColumnConstraints().isEmpty()) {
                this.grid.getColumnConstraints().clear();
            }
        }
    }

    private void onBoxAdded(GridCoord coordinate, CrosswordBoxViewModel boxModel) {
        this.addBoxNode(coordinate, boxModel);
        this.maybeAddColumnConstraint(coordinate);
        this.maybeAddRowConstraint(coordinate);
    }

    private void addBoxNode(GridCoord coordinate, CrosswordBoxViewModel boxModel) {
        CrosswordBoxTextField node = new CrosswordBoxTextField(boxModel);
        this.grid.add((Node)node, coordinate.column(), coordinate.row());
        this.boxNodes.put(coordinate, (Node)node);
        FXCollections.sort((ObservableList)this.grid.getChildren(), BOX_COMPARATOR);
        node.focusedProperty().addListener((observable, wasFocused, nowFocused) -> {
            if (nowFocused.booleanValue()) {
                this.currentBoxPosition.set((Object)coordinate);
            }
        });
    }

    private void maybeAddRowConstraint(GridCoord coordinate) {
        int oldRowCount;
        for (int row = oldRowCount = this.getRowCount(); row <= coordinate.row(); ++row) {
            this.addRowConstraint();
        }
    }

    private void maybeAddColumnConstraint(GridCoord coordinate) {
        int oldColumnCount;
        for (int column = oldColumnCount = this.getColumnCount(); column <= coordinate.column(); ++column) {
            this.addColumnConstraint();
        }
    }

    private void addRowConstraint() {
        RowConstraints rowConstraint = new RowConstraints();
        rowConstraint.setPercentHeight(100.0);
        this.grid.getRowConstraints().add((Object)rowConstraint);
    }

    private void addColumnConstraint() {
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(100.0);
        this.grid.getColumnConstraints().add((Object)columnConstraints);
    }

    private void initializeGridConstraints() {
        DoubleBinding paddingWidth = Bindings.createDoubleBinding(() -> this.getPadding().getLeft() + this.getPadding().getRight(), (Observable[])new Observable[]{this.paddingProperty()});
        DoubleBinding paddingHeight = Bindings.createDoubleBinding(() -> this.getPadding().getTop() + this.getPadding().getBottom(), (Observable[])new Observable[]{this.paddingProperty()});
        NumberBinding smallerSideContentSize = Bindings.min((ObservableNumberValue)this.widthProperty().subtract((ObservableNumberValue)paddingWidth), (ObservableNumberValue)this.heightProperty().subtract((ObservableNumberValue)paddingHeight));
        DoubleBinding columnPerRowRatio = Bindings.createDoubleBinding(this::columnPerRowRatio, (Observable[])new Observable[]{this.grid.getColumnConstraints(), this.grid.getRowConstraints()});
        this.grid.maxHeightProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)smallerSideContentSize, (ObservableNumberValue)smallerSideContentSize.divide((ObservableNumberValue)columnPerRowRatio)));
        this.grid.maxWidthProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)smallerSideContentSize, (ObservableNumberValue)smallerSideContentSize.multiply((ObservableNumberValue)columnPerRowRatio)));
    }

    private double columnPerRowRatio() {
        int columnCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        double ratio = columnCount == 0 || rowCount == 0 ? 1.0 : (double)columnCount / (double)rowCount;
        return ratio;
    }

    private int getRowCount() {
        return this.grid.getRowConstraints().size();
    }

    private int getColumnCount() {
        return this.grid.getColumnConstraints().size();
    }

    private final class SlotOrientationChanger
    implements EventHandler<InputEvent> {
        final /* synthetic */ CrosswordGridPane this$0;

        private SlotOrientationChanger(CrosswordGridPane crosswordGridPane) {
            CrosswordGridPane crosswordGridPane2 = crosswordGridPane;
            Objects.requireNonNull(crosswordGridPane2);
            this.this$0 = crosswordGridPane2;
        }

        public void handle(InputEvent event) {
            if (SlotOrientationChanger.enterKeyPressed(event) || SlotOrientationChanger.doublePrimaryClick(event) || this.arrowKeyPressedOrthogonalToSlotOrientation(event)) {
                this.this$0.currentSlotVertical.set(!this.this$0.currentSlotVertical.get());
            }
        }

        private static boolean enterKeyPressed(InputEvent event) {
            return event.getEventType() == KeyEvent.KEY_PRESSED && ((KeyEvent)event).getCode() == KeyCode.ENTER;
        }

        private static boolean doublePrimaryClick(InputEvent event) {
            return event.getEventType() == MouseEvent.MOUSE_CLICKED && ((MouseEvent)event).getButton() == MouseButton.PRIMARY && ((MouseEvent)event).getClickCount() == 2;
        }

        private boolean arrowKeyPressedOrthogonalToSlotOrientation(InputEvent event) {
            boolean bl;
            block7: {
                block6: {
                    if (event.getEventType() != KeyEvent.KEY_PRESSED) break block6;
                    switch (((KeyEvent)event).getCode()) {
                        case UP: 
                        case DOWN: {
                            if (!this.this$0.currentSlotVertical.get()) {
                                break;
                            }
                            break block6;
                        }
                        case LEFT: 
                        case RIGHT: {
                            if (this.this$0.currentSlotVertical.get()) {
                                break;
                            }
                            break block6;
                        }
                        default: {
                            break block6;
                        }
                    }
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            return bl;
        }
    }

    private final class ArrowKeyNavigator
    implements EventHandler<KeyEvent> {
        final /* synthetic */ CrosswordGridPane this$0;

        private ArrowKeyNavigator(CrosswordGridPane crosswordGridPane) {
            CrosswordGridPane crosswordGridPane2 = crosswordGridPane;
            Objects.requireNonNull(crosswordGridPane2);
            this.this$0 = crosswordGridPane2;
        }

        public void handle(KeyEvent event) {
            if (event.getCode().isArrowKey()) {
                GridCoord currentCoordinate = (GridCoord)this.this$0.currentBoxPosition.get();
                GridCoord nextCoordinate = switch (event.getCode()) {
                    case KeyCode.LEFT -> currentCoordinate.left();
                    case KeyCode.RIGHT -> currentCoordinate.right();
                    case KeyCode.UP -> currentCoordinate.up();
                    case KeyCode.DOWN -> currentCoordinate.down();
                    default -> currentCoordinate;
                };
                Node nextNode = this.this$0.boxNodes.get(nextCoordinate);
                if (nextNode != null) {
                    nextNode.requestFocus();
                }
                event.consume();
            }
        }
    }

    private final class AutoMoveCurrentBox
    implements EventHandler<KeyEvent> {
        final /* synthetic */ CrosswordGridPane this$0;

        private AutoMoveCurrentBox(CrosswordGridPane crosswordGridPane) {
            CrosswordGridPane crosswordGridPane2 = crosswordGridPane;
            Objects.requireNonNull(crosswordGridPane2);
            this.this$0 = crosswordGridPane2;
        }

        public void handle(KeyEvent event) {
            if (event.getCode().isLetterKey()) {
                this.ifNotShaded(Move.TO_NEXT);
            } else if (event.getCode() == KeyCode.BACK_SPACE) {
                this.ifNotShaded(Move.TO_PREVIOUS);
            }
        }

        private void ifNotShaded(Move move) {
            GridCoord newCoordinate;
            Node newNode;
            GridCoord currentCoordinate = (GridCoord)this.this$0.currentBoxPosition.get();
            if (!((CrosswordBoxViewModel)this.this$0.boxModels.get((Object)currentCoordinate)).isShaded() && (newNode = this.this$0.boxNodes.get(newCoordinate = move.apply(currentCoordinate, this.this$0.currentSlotVertical.get()))) != null && !((CrosswordBoxViewModel)this.this$0.boxModels.get((Object)newCoordinate)).isShaded()) {
                newNode.requestFocus();
            }
        }

        private static enum Move implements BiFunction<GridCoord, Boolean, GridCoord>
        {
            TO_NEXT,
            TO_PREVIOUS;


            @Override
            public GridCoord apply(GridCoord coord, Boolean verticalSlot) {
                return switch (this.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        if (verticalSlot.booleanValue()) {
                            yield coord.down();
                        }
                        yield coord.right();
                    }
                    case 1 -> verticalSlot != false ? coord.up() : coord.left();
                };
            }
        }
    }
}

