/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view;

import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.control.Accordion;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TitledPane;
import javafx.scene.input.MouseButton;
import re.belv.croiseur.gui.view.DictionaryListCell;
import re.belv.croiseur.gui.view.FxmlLoaderHelper;
import re.belv.croiseur.gui.view.model.DictionaryViewModel;

public final class DictionariesPane
extends Accordion {
    private final ListProperty<DictionaryViewModel> dictionaries = new SimpleListProperty((Object)this, "dictionaries", FXCollections.observableArrayList());
    private final ListProperty<String> words = new SimpleListProperty((Object)this, "words", FXCollections.observableArrayList());
    private final ListProperty<String> suggestions = new SimpleListProperty((Object)this, "suggestions", FXCollections.observableArrayList());
    private final ObjectProperty<Consumer<String>> onSuggestionSelected = new SimpleObjectProperty((Object)this, "onSuggestionSelected");
    @FXML
    private ListView<DictionaryViewModel> dictionariesListView;
    @FXML
    private TextField searchTextField;
    @FXML
    private ListView<String> wordsListView;
    @FXML
    private ListView<String> suggestionsListView;

    public DictionariesPane() {
        FxmlLoaderHelper.load((Object)this, ResourceBundle.getBundle(((Object)((Object)this)).getClass().getName()));
    }

    @FXML
    private void initialize() {
        this.initializeTitledPanes();
        this.initializeDictionariesListView();
        this.initializeSearchTextField();
        this.initializeWordsListView();
        this.initializeSuggestionsListView();
    }

    private void initializeTitledPanes() {
        this.expandedPaneProperty().addListener((observable, oldValue, newValue) -> {
            boolean hasExpanded = this.getPanes().stream().anyMatch(TitledPane::isExpanded);
            if (!hasExpanded && oldValue != null) {
                Platform.runLater(() -> this.setExpandedPane((TitledPane)oldValue));
            }
        });
        this.setExpandedPane((TitledPane)this.getPanes().get(0));
    }

    private void initializeDictionariesListView() {
        this.dictionariesListView.setCellFactory(list -> new DictionaryListCell());
        this.dictionariesListView.setItems(this.dictionaries);
    }

    private void initializeSearchTextField() {
        this.searchTextField.setTextFormatter(new TextFormatter(change -> {
            change.setText(change.getText().toUpperCase());
            return change;
        }));
    }

    private void initializeWordsListView() {
        Predicate<String> matchesSearch = word -> word.startsWith(this.searchTextField.getText());
        ObjectBinding searchPredicate = Bindings.createObjectBinding(() -> matchesSearch, (Observable[])new Observable[]{this.searchTextField.textProperty(), this.dictionariesListView.itemsProperty()});
        FilteredList searchedWords = new FilteredList(this.words);
        searchedWords.predicateProperty().bind((ObservableValue)searchPredicate);
        this.wordsListView.setItems((ObservableList)searchedWords);
    }

    private void initializeSuggestionsListView() {
        this.suggestionsListView.setItems(this.suggestions);
        this.suggestionsListView.setOnMouseClicked(event -> {
            String selectedSuggestion;
            if (event.getButton() == MouseButton.PRIMARY && this.onSuggestionSelected.get() != null && (selectedSuggestion = (String)this.suggestionsListView.getSelectionModel().getSelectedItem()) != null) {
                ((Consumer)this.onSuggestionSelected.get()).accept(selectedSuggestion);
            }
        });
    }

    public ListProperty<String> wordsProperty() {
        return this.words;
    }

    public ListProperty<DictionaryViewModel> dictionariesProperty() {
        return this.dictionaries;
    }

    public ListProperty<String> suggestionsProperty() {
        return this.suggestions;
    }

    public ObjectProperty<Consumer<String>> onSuggestionSelected() {
        return this.onSuggestionSelected;
    }
}

