/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view.javafx.scene.control;

import java.util.Set;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Region;

public final class ExpandableTextArea
extends TextArea {
    private Double insets;
    private Set<Node> textNodes;

    protected void layoutChildren() {
        super.layoutChildren();
        double computedHeight = this.recomputeHeight();
        if (this.currentHeightDiffersFrom(computedHeight)) {
            this.setMinMaxPrefHeightsTo(computedHeight);
            Platform.runLater(() -> ((ExpandableTextArea)this).requestLayout());
        }
    }

    private double recomputeHeight() {
        return this.insets() + this.text().getLayoutBounds().getHeight();
    }

    private double insets() {
        if (this.insets == null) {
            Region scrollPane = (Region)this.lookup(".scroll-pane");
            Region content = (Region)this.lookup(".content");
            double textAreaInsets = this.getInsets().getTop() + this.getInsets().getBottom();
            double scrollInsets = scrollPane.getInsets().getTop() + scrollPane.getInsets().getBottom();
            double contentInsets = content.getInsets().getTop() + content.getInsets().getBottom();
            this.insets = textAreaInsets + scrollInsets + contentInsets;
        }
        return this.insets;
    }

    private Node text() {
        if (this.textNodes == null) {
            this.textNodes = this.lookupAll(".text");
        }
        return this.textNodes.stream().filter(Node::isVisible).findFirst().orElseThrow();
    }

    private boolean currentHeightDiffersFrom(double newHeight) {
        return Math.abs(this.getHeight() - newHeight) > 1.0;
    }

    private void setMinMaxPrefHeightsTo(double height) {
        this.setMinHeight(height);
        this.setMaxHeight(height);
        this.setPrefHeight(height);
    }
}

