/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.puzzle.codec.xd.model;

import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class XdMetadata {
    private final Map<String, String> otherProperties;
    private final String title;
    private final String author;
    private final String editor;
    private final String copyright;
    private final LocalDate date;

    private XdMetadata(Builder builder) {
        this.title = builder.title;
        this.author = builder.author;
        this.editor = builder.editor;
        this.copyright = builder.copyright;
        this.date = builder.date;
        this.otherProperties = new HashMap<String, String>(builder.otherProperties);
    }

    public Map<String, String> otherProperties() {
        return Collections.unmodifiableMap(this.otherProperties);
    }

    public Optional<String> author() {
        return Optional.ofNullable(this.author);
    }

    public Optional<LocalDate> date() {
        return Optional.ofNullable(this.date);
    }

    public Optional<String> copyright() {
        return Optional.ofNullable(this.copyright);
    }

    public Optional<String> editor() {
        return Optional.ofNullable(this.editor);
    }

    public Optional<String> title() {
        return Optional.ofNullable(this.title);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XdMetadata)) {
            return false;
        }
        XdMetadata that = (XdMetadata)o;
        return Objects.equals(this.otherProperties, that.otherProperties) && Objects.equals(this.title, that.title) && Objects.equals(this.author, that.author) && Objects.equals(this.editor, that.editor) && Objects.equals(this.copyright, that.copyright) && Objects.equals(this.date, that.date);
    }

    public int hashCode() {
        return Objects.hash(this.otherProperties, this.title, this.author, this.editor, this.copyright, this.date);
    }

    public String toString() {
        return "XdMetadata{otherProperties=" + String.valueOf(this.otherProperties) + ", title='" + this.title + "', author='" + this.author + "', editor='" + this.editor + "', copyright='" + this.copyright + "', date=" + String.valueOf(this.date) + "}";
    }

    public static final class Builder {
        private final Map<String, String> otherProperties = new HashMap<String, String>();
        private String title;
        private String author;
        private String editor;
        private String copyright;
        private LocalDate date;

        public Builder title(String titleValue) {
            this.title = Objects.requireNonNull(titleValue);
            return this;
        }

        public Builder author(String authorValue) {
            this.author = Objects.requireNonNull(authorValue);
            return this;
        }

        public Builder editor(String editorValue) {
            this.editor = Objects.requireNonNull(editorValue);
            return this;
        }

        public Builder copyright(String copyrightValue) {
            this.copyright = Objects.requireNonNull(copyrightValue);
            return this;
        }

        public Builder date(LocalDate dateValue) {
            this.date = Objects.requireNonNull(dateValue);
            return this;
        }

        public Builder otherProperty(String key, String value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            this.otherProperties.put(key, value);
            return this;
        }

        public XdMetadata build() {
            return new XdMetadata(this);
        }

        public void reset() {
            this.title = null;
            this.author = null;
            this.editor = null;
            this.copyright = null;
            this.date = null;
            this.otherProperties.clear();
        }
    }
}

