/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.puzzle.repository.filesystem.plugin;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.BiPredicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import re.belv.croiseur.common.puzzle.ChangedPuzzle;
import re.belv.croiseur.common.puzzle.Puzzle;
import re.belv.croiseur.common.puzzle.SavedPuzzle;
import re.belv.croiseur.puzzle.repository.filesystem.plugin.PuzzleReader;
import re.belv.croiseur.puzzle.repository.filesystem.plugin.PuzzleRepositoryPath;
import re.belv.croiseur.puzzle.repository.filesystem.plugin.PuzzleWriter;
import re.belv.croiseur.spi.puzzle.repository.PuzzleRepository;
import re.belv.croiseur.spi.puzzle.repository.WriteException;

public final class FileSystemPuzzleRepository
implements PuzzleRepository {
    private static final Logger LOGGER = Logger.getLogger(FileSystemPuzzleRepository.class.getName());
    private static final Pattern SUPPORTED_FILES_PATTERN = Pattern.compile("\\d+.xd");
    private static final BiPredicate<Path, BasicFileAttributes> SUPPORTED_FILES = (path, attr) -> attr.isRegularFile() && SUPPORTED_FILES_PATTERN.matcher(path.getFileName().toString()).matches();
    private final Path repositoryPath = PuzzleRepositoryPath.get();
    private final PuzzleReader reader;
    private final PuzzleWriter writer;

    public FileSystemPuzzleRepository() throws IOException {
        LOGGER.info("Initializing FileSystemPuzzleRepository at " + String.valueOf(this.repositoryPath));
        if (Files.notExists(this.repositoryPath, new LinkOption[0])) {
            Files.createDirectories(this.repositoryPath, new FileAttribute[0]);
        }
        this.reader = new PuzzleReader();
        this.writer = new PuzzleWriter();
    }

    public SavedPuzzle create(Puzzle puzzle) throws WriteException {
        long id = this.nextId().orElseThrow(() -> new WriteException("Repository is full, no more id available"));
        SavedPuzzle savedPuzzle = new SavedPuzzle(id, puzzle, 1);
        this.writer.write(savedPuzzle, this.pathOf(id));
        return savedPuzzle;
    }

    public SavedPuzzle update(ChangedPuzzle changedPuzzle) throws WriteException {
        long id = changedPuzzle.id();
        SavedPuzzle original = this.query(id).orElseThrow(() -> new WriteException("Cannot updated puzzle with id " + id + ": Puzzle doesn't exist."));
        if (original.data().equals((Object)changedPuzzle.data())) {
            return original;
        }
        SavedPuzzle updated = new SavedPuzzle(id, changedPuzzle.data(), original.revision() + 1);
        this.writer.write(updated, this.pathOf(id));
        return updated;
    }

    public void delete(long id) throws WriteException {
        try {
            Files.delete(this.pathOf(id));
        }
        catch (IOException e) {
            throw new WriteException("Failed to delete puzzle with id " + id, (Throwable)e);
        }
    }

    public void deleteAll() throws WriteException {
        try (Stream<Path> paths = this.puzzlePaths();){
            Iterator it = paths.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                Files.delete(path);
            }
        }
        catch (IOException e) {
            throw new WriteException("Failed to delete puzzles.", (Throwable)e);
        }
    }

    public Optional<SavedPuzzle> query(long id) {
        return this.reader.read(this.pathOf(id));
    }

    public Collection<SavedPuzzle> list() {
        List<SavedPuzzle> list;
        block8: {
            Stream<Path> paths = this.puzzlePaths();
            try {
                list = paths.map(this.reader::read).flatMap(Optional::stream).toList();
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warning(() -> "Failed to read puzzles: " + e.getMessage());
                    LOGGER.log(Level.FINE, "", e);
                    return Collections.emptyList();
                }
            }
            paths.close();
        }
        return list;
    }

    private Stream<Path> puzzlePaths() throws IOException {
        return Files.find(this.repositoryPath, 1, SUPPORTED_FILES, new FileVisitOption[0]);
    }

    private Path pathOf(long id) {
        return this.repositoryPath.resolve(id + ".xd");
    }

    private OptionalLong nextId() {
        for (long id = 1L; id < Long.MAX_VALUE; ++id) {
            if (Files.exists(this.pathOf(id), new LinkOption[0])) continue;
            return OptionalLong.of(id);
        }
        return OptionalLong.empty();
    }
}

