/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.puzzle.repository.filesystem.plugin;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import re.belv.croiseur.common.puzzle.GridPosition;
import re.belv.croiseur.common.puzzle.Puzzle;
import re.belv.croiseur.common.puzzle.PuzzleClues;
import re.belv.croiseur.common.puzzle.PuzzleDetails;
import re.belv.croiseur.common.puzzle.PuzzleGrid;
import re.belv.croiseur.common.puzzle.SavedPuzzle;
import re.belv.croiseur.puzzle.codec.xd.model.XdClue;
import re.belv.croiseur.puzzle.codec.xd.model.XdClues;
import re.belv.croiseur.puzzle.codec.xd.model.XdCrossword;
import re.belv.croiseur.puzzle.codec.xd.model.XdGrid;
import re.belv.croiseur.puzzle.codec.xd.model.XdMetadata;
import re.belv.croiseur.puzzle.repository.filesystem.plugin.PuzzleConversionException;

final class PuzzleConverter {
    private static final String REVISION_METADATA_KEY = "x-croiseur-revision";

    private PuzzleConverter() {
    }

    static SavedPuzzle toDomain(long id, XdCrossword persistenceCrosswordModel) throws PuzzleConversionException {
        int revision = PuzzleConverter.extractRevision(persistenceCrosswordModel.metadata());
        PuzzleDetails details = PuzzleConverter.toDomain(persistenceCrosswordModel.metadata());
        PuzzleGrid grid = PuzzleConverter.toDomain(persistenceCrosswordModel.grid());
        PuzzleClues clues = PuzzleConverter.toDomain(persistenceCrosswordModel.clues());
        Puzzle puzzle = new Puzzle(details, grid, clues);
        return new SavedPuzzle(id, puzzle, revision);
    }

    static XdCrossword toPersistence(SavedPuzzle puzzle) {
        XdMetadata metadata = PuzzleConverter.toPersistence(puzzle.details(), puzzle.revision());
        XdGrid grid = PuzzleConverter.toPersistence(puzzle.grid());
        XdClues clues = PuzzleConverter.toPersistence(puzzle.grid(), puzzle.clues());
        return new XdCrossword(metadata, grid, clues);
    }

    private static int extractRevision(XdMetadata metadata) throws PuzzleConversionException {
        String value = (String)metadata.otherProperties().get(REVISION_METADATA_KEY);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new PuzzleConversionException("Cannot read revision", e);
        }
    }

    private static PuzzleGrid toDomain(XdGrid persistenceGridModel) throws PuzzleConversionException {
        if (!persistenceGridModel.spaces().isEmpty()) {
            throw new PuzzleConversionException("Cannot convert grid with spaces: This is not supported by Croiseur.");
        }
        PuzzleGrid.Builder builder = new PuzzleGrid.Builder();
        persistenceGridModel.blocks().stream().map(PuzzleConverter::toDomain).forEach(arg_0 -> ((PuzzleGrid.Builder)builder).shade(arg_0));
        persistenceGridModel.filled().forEach((index, letter) -> builder.fill(PuzzleConverter.toDomain(index), Character.valueOf(letter.charAt(0))));
        return builder.width(PuzzleConverter.width(persistenceGridModel)).height(PuzzleConverter.height(persistenceGridModel)).build();
    }

    private static PuzzleDetails toDomain(XdMetadata persistenceMetadataModel) {
        return new PuzzleDetails(persistenceMetadataModel.title().orElse(""), persistenceMetadataModel.author().orElse(""), persistenceMetadataModel.editor().orElse(""), persistenceMetadataModel.copyright().orElse(""), persistenceMetadataModel.date());
    }

    private static PuzzleClues toDomain(XdClues persistenceCluesModel) {
        List<String> acrossClues = persistenceCluesModel.acrossClues().stream().map(XdClue::clue).toList();
        List<String> downClues = persistenceCluesModel.downClues().stream().map(XdClue::clue).toList();
        return new PuzzleClues(acrossClues, downClues);
    }

    private static GridPosition toDomain(XdGrid.Index persistenceGridPosition) {
        return new GridPosition(persistenceGridPosition.column(), persistenceGridPosition.row());
    }

    private static int width(XdGrid persistenceGridModel) throws PuzzleConversionException {
        return PuzzleConverter.maxDimension(persistenceGridModel, XdGrid.Index::column);
    }

    private static int height(XdGrid persistenceGridModel) throws PuzzleConversionException {
        return PuzzleConverter.maxDimension(persistenceGridModel, XdGrid.Index::row);
    }

    private static int maxDimension(XdGrid persistedGrid, Function<XdGrid.Index, Integer> dimension) throws PuzzleConversionException {
        return 1 + Stream.of(persistedGrid.blocks(), persistedGrid.filled().keySet(), persistedGrid.nonFilled()).flatMap(Collection::stream).map(dimension).max(Comparator.naturalOrder()).orElseThrow(() -> new PuzzleConversionException("Invalid empty grid"));
    }

    private static XdMetadata toPersistence(PuzzleDetails details, int revision) {
        XdMetadata.Builder builder = new XdMetadata.Builder();
        if (!details.title().isEmpty()) {
            builder.title(details.title());
        }
        if (!details.author().isEmpty()) {
            builder.author(details.author());
        }
        if (!details.editor().isEmpty()) {
            builder.editor(details.editor());
        }
        if (!details.copyright().isEmpty()) {
            builder.copyright(details.copyright());
        }
        details.date().ifPresent(arg_0 -> ((XdMetadata.Builder)builder).date(arg_0));
        builder.otherProperty(REVISION_METADATA_KEY, String.valueOf(revision));
        return builder.build();
    }

    private static XdGrid toPersistence(PuzzleGrid grid) {
        XdGrid.Builder builder = new XdGrid.Builder();
        for (int row = 0; row < grid.height(); ++row) {
            for (int column = 0; column < grid.width(); ++column) {
                Character letter = (Character)grid.filled().get(GridPosition.at((int)column, (int)row));
                if (letter != null) {
                    builder.filled(XdGrid.Index.at((int)column, (int)row), letter.charValue());
                    continue;
                }
                if (grid.shaded().contains(GridPosition.at((int)column, (int)row))) {
                    builder.block(XdGrid.Index.at((int)column, (int)row));
                    continue;
                }
                builder.nonFilled(XdGrid.Index.at((int)column, (int)row));
            }
        }
        return builder.build();
    }

    private static XdClues toPersistence(PuzzleGrid grid, PuzzleClues clues) {
        XdClues.Builder builder = new XdClues.Builder();
        List acrossSlotsContents = grid.acrossSlotContents();
        List acrossClues = clues.across();
        for (int i = 0; i < acrossClues.size(); ++i) {
            builder.across(i + 1, (String)acrossClues.get(i), (String)acrossSlotsContents.get(i));
        }
        List downSlotContents = grid.downSlotContents();
        List downClues = clues.down();
        for (int i = 0; i < downClues.size(); ++i) {
            builder.down(i + 1, (String)downClues.get(i), (String)downSlotContents.get(i));
        }
        return builder.build();
    }
}

