/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.CompletionsUsage;
import com.azure.ai.openai.models.ContentFilterResultsForPrompt;
import com.azure.ai.openai.models.ServiceTier;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;

public final class ChatCompletions
implements JsonSerializable<ChatCompletions> {
    private final String id;
    private final List<ChatChoice> choices;
    private CompletionsUsage usage;
    private ServiceTier serviceTier;
    private final long createdAt;
    private List<ContentFilterResultsForPrompt> promptFilterResults;
    private String systemFingerprint;
    private String model;

    public String getId() {
        return this.id;
    }

    public List<ChatChoice> getChoices() {
        return this.choices;
    }

    public CompletionsUsage getUsage() {
        return this.usage;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public ServiceTier getServiceTier() {
        return this.serviceTier;
    }

    public List<ContentFilterResultsForPrompt> getPromptFilterResults() {
        return this.promptFilterResults;
    }

    public String getSystemFingerprint() {
        return this.systemFingerprint;
    }

    public String getModel() {
        return this.model;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeLongField("created", this.createdAt);
        jsonWriter.writeArrayField("choices", this.choices, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("usage", (JsonSerializable)this.usage);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeArrayField("prompt_filter_results", this.promptFilterResults, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("system_fingerprint", this.systemFingerprint);
        if (this.serviceTier != null) {
            jsonWriter.writeStringField("service_tier", this.serviceTier.toString());
        }
        return jsonWriter.writeEndObject();
    }

    public static ChatCompletions fromJson(JsonReader jsonReader) throws IOException {
        return (ChatCompletions)jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            List choices = null;
            CompletionsUsage usage = null;
            String model = null;
            List promptFilterResults = null;
            ServiceTier serviceTier = null;
            String systemFingerprint = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("created".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("choices".equals(fieldName)) {
                    choices = reader.readArray(reader1 -> ChatChoice.fromJson(reader1));
                    continue;
                }
                if ("usage".equals(fieldName)) {
                    usage = CompletionsUsage.fromJson(reader);
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if ("prompt_filter_results".equals(fieldName)) {
                    promptFilterResults = reader.readArray(reader1 -> ContentFilterResultsForPrompt.fromJson(reader1));
                    continue;
                }
                if ("system_fingerprint".equals(fieldName)) {
                    systemFingerprint = reader.getString();
                    continue;
                }
                if ("service_tier".equals(fieldName)) {
                    serviceTier = ServiceTier.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ChatCompletions deserializedChatCompletions = new ChatCompletions(id, createdAt, choices);
            deserializedChatCompletions.model = model;
            deserializedChatCompletions.promptFilterResults = promptFilterResults;
            deserializedChatCompletions.systemFingerprint = systemFingerprint;
            deserializedChatCompletions.serviceTier = serviceTier;
            deserializedChatCompletions.usage = usage;
            return deserializedChatCompletions;
        });
    }

    private ChatCompletions(String id, OffsetDateTime createdAt, List<ChatChoice> choices) {
        this.id = id;
        this.createdAt = createdAt == null ? 0L : createdAt.toEpochSecond();
        this.choices = choices;
    }
}

