/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.AzureChatExtensionConfiguration;
import com.azure.ai.openai.models.AzureChatExtensionType;
import com.azure.ai.openai.models.PineconeChatExtensionParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class PineconeChatExtensionConfiguration
extends AzureChatExtensionConfiguration {
    private final PineconeChatExtensionParameters parameters;
    private AzureChatExtensionType type = AzureChatExtensionType.PINECONE;

    public PineconeChatExtensionParameters getParameters() {
        return this.parameters;
    }

    public PineconeChatExtensionConfiguration(PineconeChatExtensionParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public AzureChatExtensionType getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static PineconeChatExtensionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (PineconeChatExtensionConfiguration)jsonReader.readObject(reader -> {
            PineconeChatExtensionParameters parameters = null;
            AzureChatExtensionType type = AzureChatExtensionType.PINECONE;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    parameters = PineconeChatExtensionParameters.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = AzureChatExtensionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            PineconeChatExtensionConfiguration deserializedPineconeChatExtensionConfiguration = new PineconeChatExtensionConfiguration(parameters);
            deserializedPineconeChatExtensionConfiguration.type = type;
            return deserializedPineconeChatExtensionConfiguration;
        });
    }
}

