/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesContent;
import com.azure.ai.openai.responses.models.ResponsesContentType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesOutputContentRefusal
extends ResponsesContent {
    private ResponsesContentType type = ResponsesContentType.REFUSAL;
    private final String refusal;

    public ResponsesOutputContentRefusal(String refusal) {
        this.refusal = refusal;
    }

    @Override
    public ResponsesContentType getType() {
        return this.type;
    }

    public String getRefusal() {
        return this.refusal;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("refusal", this.refusal);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesOutputContentRefusal fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesOutputContentRefusal)jsonReader.readObject(reader -> {
            String refusal = null;
            ResponsesContentType type = ResponsesContentType.REFUSAL;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("refusal".equals(fieldName)) {
                    refusal = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesContentType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesOutputContentRefusal deserializedResponsesOutputContentRefusal = new ResponsesOutputContentRefusal(refusal);
            deserializedResponsesOutputContentRefusal.type = type;
            return deserializedResponsesOutputContentRefusal;
        });
    }
}

