/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesStreamEvent;
import com.azure.ai.openai.responses.models.ResponsesStreamEventType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesStreamEventFunctionCallArgumentsDone
extends ResponsesStreamEvent {
    private ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE;
    private final String itemId;
    private final int outputIndex;
    private final String arguments;

    private ResponsesStreamEventFunctionCallArgumentsDone(String itemId, int outputIndex, String arguments) {
        this.itemId = itemId;
        this.outputIndex = outputIndex;
        this.arguments = arguments;
    }

    @Override
    public ResponsesStreamEventType getType() {
        return this.type;
    }

    public String getItemId() {
        return this.itemId;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public String getArguments() {
        return this.arguments;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("item_id", this.itemId);
        jsonWriter.writeIntField("output_index", this.outputIndex);
        jsonWriter.writeStringField("arguments", this.arguments);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesStreamEventFunctionCallArgumentsDone fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesStreamEventFunctionCallArgumentsDone)jsonReader.readObject(reader -> {
            String itemId = null;
            int outputIndex = 0;
            String arguments = null;
            ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("item_id".equals(fieldName)) {
                    itemId = reader.getString();
                    continue;
                }
                if ("output_index".equals(fieldName)) {
                    outputIndex = reader.getInt();
                    continue;
                }
                if ("arguments".equals(fieldName)) {
                    arguments = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesStreamEventType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesStreamEventFunctionCallArgumentsDone deserializedResponsesStreamEventFunctionCallArgumentsDone = new ResponsesStreamEventFunctionCallArgumentsDone(itemId, outputIndex, arguments);
            deserializedResponsesStreamEventFunctionCallArgumentsDone.type = type;
            return deserializedResponsesStreamEventFunctionCallArgumentsDone;
        });
    }
}

