/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.dictionary;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import re.belv.croiseur.solver.ginsberg.Dictionary;
import re.belv.croiseur.solver.ginsberg.core.Slot;
import re.belv.croiseur.solver.ginsberg.core.SlotIdentifier;
import re.belv.croiseur.solver.ginsberg.dictionary.CachedDictionaryWriter;
import re.belv.croiseur.solver.ginsberg.dictionary.SizedMap;
import re.belv.croiseur.solver.ginsberg.dictionary.Trie;
import re.belv.croiseur.solver.ginsberg.elimination.EliminationSpace;

final class CachedDictionaryImpl
implements CachedDictionaryWriter {
    private static final int CACHED_PATTERNS_PER_SLOT = 1000;
    private final Map<SlotIdentifier, Trie> initialCandidates;
    private final Map<String, List<String>> wordsByPattern;
    private final Map<SlotIdentifier, Long> currentCandidatesCount;
    private final EliminationSpace els;

    CachedDictionaryImpl(Dictionary dictionary, Collection<Slot> slots, EliminationSpace eliminationSpace) {
        this.els = eliminationSpace;
        this.initialCandidates = CachedDictionaryImpl.createInitialCandidates(dictionary, slots);
        this.wordsByPattern = new SizedMap<String, List<String>>(slots.size() * 1000);
        this.currentCandidatesCount = new HashMap<SlotIdentifier, Long>();
    }

    private static Map<SlotIdentifier, Trie> createInitialCandidates(Dictionary dictionary, Collection<Slot> slots) {
        Collection<List<Slot>> slotGroups = slots.stream().collect(Collectors.groupingBy(Slot::asPattern)).values();
        HashMap<SlotIdentifier, Trie> tries = new HashMap<SlotIdentifier, Trie>();
        Collection<String> words = dictionary.words();
        for (List<Slot> slotGroup : slotGroups) {
            Trie trie = new Trie();
            Slot referenceSlot = slotGroup.get(0);
            for (String word : words) {
                if (!referenceSlot.isCompatibleWith(word)) continue;
                trie.add(word);
            }
            for (Slot slot : slotGroup) {
                tries.put(slot.uid(), trie);
            }
        }
        return tries;
    }

    @Override
    public Stream<String> candidates(Slot slot) {
        return this.wordsFromPattern(slot).stream().filter(Predicate.not(this.els.eliminatedValues(slot.uid())::contains));
    }

    @Override
    public long cachedCandidatesCount(Slot slot) {
        return this.currentCandidatesCount.computeIfAbsent(slot.uid(), k -> this.candidates(slot).count());
    }

    @Override
    public Stream<String> reevaluatedCandidates(Slot slot) {
        return this.initialCandidates.get(slot.uid()).streamMatching(slot.asPattern());
    }

    @Override
    public void invalidateCacheCount(Slot modifiedSlot) {
        this.currentCandidatesCount.remove(modifiedSlot.uid());
        modifiedSlot.connectedSlots().forEach(slot -> this.currentCandidatesCount.remove(slot.uid()));
    }

    private List<String> wordsFromPattern(Slot slot) {
        String slotPattern = slot.asPattern();
        return this.wordsByPattern.computeIfAbsent(slotPattern, k -> this.initialCandidates.get(slot.uid()).streamMatching(slotPattern).toList());
    }
}

