/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.grid;

import java.util.NoSuchElementException;
import re.belv.croiseur.solver.ginsberg.grid.BoxData;

final class Boxes {
    private static final BoxData SHADED = new ShadedBox();

    private Boxes() {
    }

    static BoxData shaded() {
        return SHADED;
    }

    static BoxData computed() {
        return new ComputedBox();
    }

    static BoxData prefilled(char character) {
        return new PrefilledBox(character);
    }

    private static final class ComputedBox
    implements BoxData {
        private static char EMPTY_VALUE = (char)32;
        private char character;

        ComputedBox() {
            this.character = EMPTY_VALUE;
        }

        private ComputedBox(ComputedBox other) {
            this.character = other.character;
        }

        @Override
        public char value() {
            if (this.character == EMPTY_VALUE) {
                throw new NoSuchElementException("Box is empty");
            }
            return this.character;
        }

        @Override
        public boolean isShaded() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.character == EMPTY_VALUE;
        }

        @Override
        public void set(char aCharacter) {
            this.character = aCharacter;
        }

        @Override
        public void reset() {
            this.character = EMPTY_VALUE;
        }

        @Override
        public BoxData copy() {
            return new ComputedBox(this);
        }

        public String toString() {
            return String.valueOf(this.character);
        }
    }

    private static final class PrefilledBox
    implements BoxData {
        private final char character;

        PrefilledBox(char aCharacter) {
            this.character = aCharacter;
        }

        @Override
        public char value() {
            return this.character;
        }

        @Override
        public boolean isShaded() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void set(char aCharacter) {
            if (this.character != aCharacter) {
                throw new UnsupportedOperationException("Illegal attempt to modify a prefilled box");
            }
        }

        @Override
        public void reset() {
        }

        @Override
        public BoxData copy() {
            return this;
        }

        public String toString() {
            return String.valueOf(this.character);
        }
    }

    private static final class ShadedBox
    implements BoxData {
        private static final String SHADED_BOXES_ARE_IMMUTABLE = "Shaded boxes are immutable";

        ShadedBox() {
        }

        @Override
        public char value() {
            throw new NoSuchElementException("Shaded box has no value");
        }

        @Override
        public boolean isShaded() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void set(char aCharacter) {
            throw new UnsupportedOperationException(SHADED_BOXES_ARE_IMMUTABLE);
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException(SHADED_BOXES_ARE_IMMUTABLE);
        }

        @Override
        public BoxData copy() {
            return this;
        }

        public String toString() {
            return String.valueOf('#');
        }
    }
}

