/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.grid;

import java.util.NoSuchElementException;

final class SlotDefinition {
    private final int offset;
    private final int start;
    private final int end;
    private final Type type;

    SlotDefinition(int anOffset, int aStart, int aEnd, Type aType) {
        SlotDefinition.validateRange(aStart, aEnd);
        this.offset = anOffset;
        this.start = aStart;
        this.end = aEnd;
        this.type = aType;
    }

    private static void validateRange(int aStart, int aEnd) {
        if (aEnd <= aStart) {
            throw new IllegalArgumentException("Invalid slot definition");
        }
    }

    public String toString() {
        return "SlotDefinition{offset=" + this.offset + ", start=" + this.start + ", end=" + this.end + ", type=" + String.valueOf((Object)this.type) + "}";
    }

    Type type() {
        return this.type;
    }

    int offset() {
        return this.offset;
    }

    int start() {
        return this.start;
    }

    int end() {
        return this.end;
    }

    int length() {
        return this.end - this.start;
    }

    boolean isConnected(SlotDefinition other) {
        boolean differentType = this.type != other.type;
        boolean thisOffsetIncludedInOtherRange = this.offset >= other.start && this.offset < other.end;
        boolean otherOffsetIncludedInThisRange = other.offset >= this.start && other.offset < this.end;
        return differentType && thisOffsetIncludedInOtherRange && otherOffsetIncludedInThisRange;
    }

    int connectionWith(SlotDefinition other) {
        if (!this.isConnected(other)) {
            throw new NoSuchElementException();
        }
        return other.offset - this.start;
    }

    static enum Type {
        HORIZONTAL,
        VERTICAL;


        boolean isHorizontal() {
            return this == HORIZONTAL;
        }
    }
}

