/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.listener;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import re.belv.croiseur.solver.ginsberg.ProgressListener;
import re.belv.croiseur.solver.ginsberg.core.Slot;
import re.belv.croiseur.solver.ginsberg.listener.SolverListener;

public final class ProgressNotifier
implements SolverListener {
    private static final Duration PROGRESS_NOTIFICATION_INTERVAL = Duration.ofSeconds(1L);
    private final Collection<Slot> slots;
    private final ProgressListener progressListener;
    private Instant lastProgressNotificationTime;

    public ProgressNotifier(Collection<Slot> someSlots, ProgressListener aProgressListener) {
        this.slots = Collections.unmodifiableCollection(someSlots);
        this.progressListener = aProgressListener;
        this.lastProgressNotificationTime = Instant.EPOCH;
    }

    @Override
    public void onUnassignment(Slot slot, String unassignedWord) {
        this.refresh();
    }

    @Override
    public void onAssignment(Slot slot, String word) {
        this.refresh();
    }

    private short completionPercentage() {
        long slotSolved = this.slots.stream().filter(Slot::isInstantiated).count();
        return (short)(100L * slotSolved / (long)this.slots.size());
    }

    private void refresh() {
        Instant now = Instant.now();
        if (Duration.between(this.lastProgressNotificationTime, now).compareTo(PROGRESS_NOTIFICATION_INTERVAL) >= 0) {
            this.lastProgressNotificationTime = now;
            this.progressListener.onSolverProgressUpdate(this.completionPercentage());
        }
    }
}

