/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.state;

import java.util.Collection;
import re.belv.croiseur.common.puzzle.PuzzleGrid;
import re.belv.croiseur.solver.ginsberg.Dictionary;
import re.belv.croiseur.solver.ginsberg.core.Slot;
import re.belv.croiseur.solver.ginsberg.dictionary.CachedDictionaryWriter;
import re.belv.croiseur.solver.ginsberg.elimination.EliminationSpaceWriter;
import re.belv.croiseur.solver.ginsberg.grid.Grid;
import re.belv.croiseur.solver.ginsberg.history.HistoryWriter;
import re.belv.croiseur.solver.ginsberg.lookahead.ProbePuzzle;

public final class Crossword {
    private final Grid grid;
    private final ProbePuzzle probe;
    private final CachedDictionaryWriter dictionary;
    private final EliminationSpaceWriter eliminationSpace;
    private final HistoryWriter history;

    private Crossword(Grid gridArg, CachedDictionaryWriter dictionaryArg, EliminationSpaceWriter eliminationSpaceArg, HistoryWriter historyArg) {
        this.grid = gridArg;
        this.probe = new ProbePuzzle(gridArg.puzzle(), dictionaryArg, eliminationSpaceArg);
        this.dictionary = dictionaryArg;
        this.eliminationSpace = eliminationSpaceArg;
        this.history = historyArg;
    }

    public static Crossword create(PuzzleGrid puzzleGrid, Dictionary externalDictionary) {
        Grid grid = Grid.create(puzzleGrid);
        Collection<Slot> slots = grid.puzzle().slots();
        EliminationSpaceWriter eliminationSpace = EliminationSpaceWriter.create();
        CachedDictionaryWriter dictionary = CachedDictionaryWriter.create(externalDictionary, slots, eliminationSpace);
        HistoryWriter history = HistoryWriter.create();
        return new Crossword(grid, dictionary, eliminationSpace, history);
    }

    public Grid grid() {
        return this.grid;
    }

    public ProbePuzzle probePuzzle() {
        return this.probe;
    }

    public CachedDictionaryWriter dictionary() {
        return this.dictionary;
    }

    public EliminationSpaceWriter eliminationSpace() {
        return this.eliminationSpace;
    }

    public HistoryWriter history() {
        return this.history;
    }
}

