/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import re.belv.croiseur.solver.ginsberg.core.Slot;
import re.belv.croiseur.solver.ginsberg.core.SlotIdentifier;
import re.belv.croiseur.solver.ginsberg.core.sap.Elimination;
import re.belv.croiseur.solver.ginsberg.core.sap.ProblemStateUpdater;
import re.belv.croiseur.solver.ginsberg.listener.SolverListener;
import re.belv.croiseur.solver.ginsberg.state.Crossword;

public final class CrosswordUpdater
implements ProblemStateUpdater<Slot, String, SlotIdentifier> {
    private final Crossword crossword;
    private final List<SolverListener> listeners;

    public CrosswordUpdater(Crossword aCrossword) {
        this.crossword = Objects.requireNonNull(aCrossword);
        this.listeners = new ArrayList<SolverListener>();
    }

    public CrosswordUpdater withListeners(SolverListener ... someListeners) {
        this.listeners.addAll(Arrays.asList(someListeners));
        return this;
    }

    @Override
    public void assign(Slot variable, String value) {
        variable.assign(value);
        this.crossword.probePuzzle().slot(variable.uid()).assign(value);
        this.crossword.history().addAssignmentRecord(variable);
        this.crossword.dictionary().invalidateCacheCount(variable);
        this.listeners.forEach(listener -> listener.onAssignment(variable, value));
    }

    @Override
    public void unassign(Elimination<Slot, SlotIdentifier> elimination) {
        Slot variable = elimination.eliminated();
        String oldValue = variable.unassign();
        this.crossword.probePuzzle().slot(variable.uid()).unassign();
        this.crossword.history().removeAssignmentRecord(variable);
        this.crossword.eliminationSpace().eliminate(variable.uid(), elimination.reasons(), oldValue);
        this.crossword.dictionary().invalidateCacheCount(variable);
        this.listeners.forEach(listener -> listener.onUnassignment(variable, oldValue));
    }
}

