/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.clue;

import java.util.Collection;
import java.util.List;
import re.belv.croiseur.spi.clue.ClueProvider;
import re.belv.croiseur.spi.presenter.clue.CluePresenter;
import re.belv.croiseur.spi.presenter.clue.ClueProviderDescription;

final class ListClueProvidersUsecase {
    private final Collection<ClueProvider> clueProviders;
    private final CluePresenter cluePresenter;

    ListClueProvidersUsecase(Collection<ClueProvider> clueProvidersArg, CluePresenter cluePresenterArg) {
        this.clueProviders = clueProvidersArg;
        this.cluePresenter = cluePresenterArg;
    }

    void process() {
        List<ClueProviderDescription> descriptions = this.clueProviders.stream().map(clueProvider -> new ClueProviderDescription(clueProvider.name(), clueProvider.description())).toList();
        if (descriptions.isEmpty()) {
            this.cluePresenter.presentClueError("No clue provider found");
        } else {
            this.cluePresenter.presentClueProviders(descriptions);
        }
    }
}

