/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.dictionary;

import java.util.Collection;
import re.belv.croiseur.api.dictionary.DictionaryService;
import re.belv.croiseur.api.dictionary.ListDictionariesRequest;
import re.belv.croiseur.api.dictionary.ListDictionaryEntriesRequest;
import re.belv.croiseur.api.dictionary.SearchDictionaryEntriesRequest;
import re.belv.croiseur.impl.dictionary.GetDefaultDictionaryUsecase;
import re.belv.croiseur.impl.dictionary.ListDictionariesUsecase;
import re.belv.croiseur.impl.dictionary.ListDictionaryEntriesUsecase;
import re.belv.croiseur.impl.dictionary.ListDictionaryProvidersUsecase;
import re.belv.croiseur.impl.dictionary.SearchDictionaryEntriesUsecase;
import re.belv.croiseur.impl.dictionary.selection.DictionarySelector;
import re.belv.croiseur.spi.dictionary.DictionaryProvider;
import re.belv.croiseur.spi.presenter.Presenter;
import re.belv.croiseur.spi.presenter.dictionary.DictionaryPresenter;

public final class DictionaryServiceImpl
implements DictionaryService {
    private final ListDictionaryProvidersUsecase listDictionaryProvidersUsecase;
    private final ListDictionariesUsecase listDictionariesUsecase;
    private final ListDictionaryEntriesUsecase listDictionaryEntries;
    private final SearchDictionaryEntriesUsecase searchDictionaryEntries;
    private final GetDefaultDictionaryUsecase getDefaultDictionaryUsecase;

    public DictionaryServiceImpl(Collection<DictionaryProvider> dictionaryProvidersArg, Presenter presenterArg) {
        this.listDictionaryProvidersUsecase = new ListDictionaryProvidersUsecase(dictionaryProvidersArg, (DictionaryPresenter)presenterArg);
        this.listDictionariesUsecase = new ListDictionariesUsecase(dictionaryProvidersArg, (DictionaryPresenter)presenterArg);
        DictionarySelector dictionarySelector = new DictionarySelector(dictionaryProvidersArg);
        this.listDictionaryEntries = new ListDictionaryEntriesUsecase(dictionarySelector, (DictionaryPresenter)presenterArg);
        this.searchDictionaryEntries = new SearchDictionaryEntriesUsecase(dictionarySelector, (DictionaryPresenter)presenterArg);
        this.getDefaultDictionaryUsecase = new GetDefaultDictionaryUsecase(dictionarySelector, (DictionaryPresenter)presenterArg);
    }

    @Override
    public void listProviders() {
        this.listDictionaryProvidersUsecase.process();
    }

    @Override
    public void listDictionaries(ListDictionariesRequest request) {
        this.listDictionariesUsecase.process(request);
    }

    @Override
    public void listEntries(ListDictionaryEntriesRequest request) {
        this.listDictionaryEntries.process(request);
    }

    @Override
    public void searchEntries(SearchDictionaryEntriesRequest request) {
        this.searchDictionaryEntries.process(request);
    }

    @Override
    public void getDefaultDictionary() {
        this.getDefaultDictionaryUsecase.process();
    }
}

