/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.dictionary;

import java.util.Set;
import re.belv.croiseur.api.dictionary.ListDictionaryEntriesRequest;
import re.belv.croiseur.common.dictionary.ProvidedDictionaryDetails;
import re.belv.croiseur.common.util.Either;
import re.belv.croiseur.impl.dictionary.selection.DictionarySelector;
import re.belv.croiseur.impl.dictionary.selection.SelectedDictionary;
import re.belv.croiseur.spi.presenter.dictionary.DictionaryContent;
import re.belv.croiseur.spi.presenter.dictionary.DictionaryPresenter;

final class ListDictionaryEntriesUsecase {
    private final DictionarySelector dictionarySelector;
    private final DictionaryPresenter presenter;

    ListDictionaryEntriesUsecase(DictionarySelector dictionarySelectorArg, DictionaryPresenter presenterArg) {
        this.dictionarySelector = dictionarySelectorArg;
        this.presenter = presenterArg;
    }

    private static DictionaryContent readContent(SelectedDictionary selectedDictionary) {
        ProvidedDictionaryDetails details = selectedDictionary.details();
        Set<String> words = selectedDictionary.words();
        return new DictionaryContent(details, words);
    }

    void process(ListDictionaryEntriesRequest request) {
        Either<String, SelectedDictionary> dictionarySelection = this.dictionarySelector.select(request.dictionaryIdentifier());
        if (dictionarySelection.isRight()) {
            DictionaryContent dictionaryContent = ListDictionaryEntriesUsecase.readContent((SelectedDictionary)dictionarySelection.right());
            this.presenter.presentDictionaryEntries(dictionaryContent);
        } else {
            this.presenter.presentDictionaryError((String)dictionarySelection.left());
        }
    }
}

