/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.dictionary.selection;

import java.util.Comparator;
import java.util.Locale;
import re.belv.croiseur.common.dictionary.ProvidedDictionaryDetails;

public final class DictionaryComparator
implements Comparator<ProvidedDictionaryDetails> {
    private final LocaleComparator localeComparator = new LocaleComparator();
    private final ProviderNameComparator providerNameComparator = new ProviderNameComparator();

    @Override
    public int compare(ProvidedDictionaryDetails left, ProvidedDictionaryDetails right) {
        int localeComparison = this.localeComparator.compare(left.dictionaryLocale(), right.dictionaryLocale());
        if (localeComparison != 0) {
            return localeComparison;
        }
        int providerComparison = this.providerNameComparator.compare(left.providerName(), right.providerName());
        if (providerComparison != 0) {
            return providerComparison;
        }
        return (left.providerName() + left.dictionaryName()).compareTo(right.providerName() + right.dictionaryName());
    }

    private static final class LocaleComparator
    implements Comparator<Locale> {
        private static final String ENGLISH_LANGUAGE = Locale.ENGLISH.getLanguage();
        private final Locale defaultSystemLocale = Locale.getDefault();
        private final String defaultSystemLanguage = this.defaultSystemLocale.getLanguage();

        LocaleComparator() {
        }

        @Override
        public int compare(Locale left, Locale right) {
            if (left.equals(this.defaultSystemLocale) && !right.equals(this.defaultSystemLocale)) {
                return -1;
            }
            if (!left.equals(this.defaultSystemLocale) && right.equals(this.defaultSystemLocale)) {
                return 1;
            }
            if (left.getLanguage().equals(this.defaultSystemLanguage) && !right.getLanguage().equals(this.defaultSystemLanguage)) {
                return -1;
            }
            if (!left.getLanguage().equals(this.defaultSystemLanguage) && right.getLanguage().equals(this.defaultSystemLanguage)) {
                return 1;
            }
            if (left.getLanguage().equals(ENGLISH_LANGUAGE) && !right.getLanguage().equals(ENGLISH_LANGUAGE)) {
                return -1;
            }
            if (!left.getLanguage().equals(ENGLISH_LANGUAGE) && right.getLanguage().equals(ENGLISH_LANGUAGE)) {
                return 1;
            }
            return left.getLanguage().compareTo(right.getLanguage());
        }
    }

    private static final class ProviderNameComparator
    implements Comparator<String> {
        private static final String PREFERRED_PROVIDER = "Local XML Provider";

        ProviderNameComparator() {
        }

        @Override
        public int compare(String leftName, String rightName) {
            if (leftName.equals(PREFERRED_PROVIDER) && !rightName.equals(PREFERRED_PROVIDER)) {
                return -1;
            }
            if (!leftName.equals(PREFERRED_PROVIDER) && rightName.equals(PREFERRED_PROVIDER)) {
                return 1;
            }
            return 0;
        }
    }
}

