/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.dictionary.selection;

import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import re.belv.croiseur.api.dictionary.DictionaryIdentifier;
import re.belv.croiseur.common.dictionary.DictionaryProviderDetails;
import re.belv.croiseur.spi.dictionary.Dictionary;
import re.belv.croiseur.spi.dictionary.DictionaryProvider;

public final class DictionaryProviderFilter
implements UnaryOperator<Collection<DictionaryProvider>> {
    private final Predicate<DictionaryProvider> providerFilter;
    private final Predicate<Dictionary> dictionaryFilter;

    private DictionaryProviderFilter(Predicate<DictionaryProvider> providerFilterArg, Predicate<Dictionary> dictionaryFilterArg) {
        this.providerFilter = providerFilterArg;
        this.dictionaryFilter = dictionaryFilterArg;
    }

    public static DictionaryProviderFilter byName(String desiredDictionaryName) {
        return new DictionaryProviderFilter(DictionaryProviderFilter.satisfied(), dictionary -> dictionary.details().name().equals(desiredDictionaryName));
    }

    public static DictionaryProviderFilter byLocale(Locale desiredDictionaryLocale) {
        if (desiredDictionaryLocale.getCountry().isEmpty()) {
            return DictionaryProviderFilter.byLanguage(desiredDictionaryLocale.getLanguage());
        }
        return new DictionaryProviderFilter(DictionaryProviderFilter.satisfied(), dictionary -> dictionary.details().locale().equals(desiredDictionaryLocale));
    }

    public static DictionaryProviderFilter byLanguage(String desiredDictionaryLanguage) {
        return new DictionaryProviderFilter(DictionaryProviderFilter.satisfied(), dictionary -> dictionary.details().locale().getLanguage().equals(desiredDictionaryLanguage));
    }

    public static DictionaryProviderFilter byOptionalLocale(Optional<Locale> desiredDictionaryLocale) {
        return desiredDictionaryLocale.map(DictionaryProviderFilter::byLocale).orElseGet(DictionaryProviderFilter::any);
    }

    public static DictionaryProviderFilter byOptionalProvider(Optional<String> desiredProviderName) {
        return desiredProviderName.map(DictionaryProviderFilter::byProvider).orElseGet(DictionaryProviderFilter::any);
    }

    public static DictionaryProviderFilter byProvider(String desiredProviderName) {
        return new DictionaryProviderFilter(provider -> provider.details().name().equals(desiredProviderName), DictionaryProviderFilter.satisfied());
    }

    public static DictionaryProviderFilter byId(DictionaryIdentifier id) {
        return DictionaryProviderFilter.byProvider(id.providerName()).and(DictionaryProviderFilter.byName(id.dictionaryName()));
    }

    public static DictionaryProviderFilter none() {
        return new DictionaryProviderFilter(Predicate.not(DictionaryProviderFilter.satisfied()), Predicate.not(DictionaryProviderFilter.satisfied()));
    }

    public static DictionaryProviderFilter any() {
        return new DictionaryProviderFilter(DictionaryProviderFilter.satisfied(), DictionaryProviderFilter.satisfied());
    }

    private static <T> Predicate<T> satisfied() {
        return t -> true;
    }

    public DictionaryProviderFilter and(DictionaryProviderFilter other) {
        return new DictionaryProviderFilter(this.providerFilter.and(other.providerFilter), this.dictionaryFilter.and(other.dictionaryFilter));
    }

    public DictionaryProviderFilter or(DictionaryProviderFilter other) {
        return new DictionaryProviderFilter(this.providerFilter.or(other.providerFilter), this.dictionaryFilter.or(other.dictionaryFilter));
    }

    @Override
    public Collection<DictionaryProvider> apply(Collection<DictionaryProvider> providers) {
        return providers.stream().filter(this.providerFilter).map(provider -> new FilteredDictionaryProvider((DictionaryProvider)provider, this.dictionaryFilter)).filter(provider -> !provider.get().isEmpty()).collect(Collectors.toUnmodifiableList());
    }

    private static final class FilteredDictionaryProvider
    implements DictionaryProvider {
        private final DictionaryProvider actual;
        private final Collection<Dictionary> filteredDictionaries;

        FilteredDictionaryProvider(DictionaryProvider actualArg, Predicate<Dictionary> dictionaryFilterArg) {
            this.actual = actualArg;
            this.filteredDictionaries = actualArg.get().stream().filter(dictionaryFilterArg).toList();
        }

        public DictionaryProviderDetails details() {
            return this.actual.details();
        }

        public Collection<Dictionary> get() {
            return this.filteredDictionaries;
        }
    }
}

